/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.gh_everyware_server;

import com.ghe.gh_everyware_server.UserPassDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;

public class PasswordManagerDialog
extends JDialog {
    private File passwordFile;
    Object[] users;
    Map<String, byte[]> prop;
    Frame parent;
    private JButton addUserButton;
    private JButton changePassButton;
    private JScrollPane jScrollPane1;
    private JButton okButton;
    private JButton removeUserButton;
    private JList userList;

    public PasswordManagerDialog(Frame parent) {
        super(parent, false);
        this.setLocationRelativeTo(parent);
        this.prop = new HashMap<String, byte[]>();
        this.passwordFile = new File("passwords");
        this.initComponents();
        try {
            this.openFile(this.passwordFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.userList = new JList();
        this.addUserButton = new JButton();
        this.removeUserButton = new JButton();
        this.changePassButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("User Manager");
        this.setResizable(false);
        this.userList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PasswordManagerDialog.this.userListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.userList);
        this.addUserButton.setText("Add User");
        this.addUserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordManagerDialog.this.addUserButtonActionPerformed(evt);
            }
        });
        this.removeUserButton.setText("Remove User");
        this.removeUserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordManagerDialog.this.removeUserButtonActionPerformed(evt);
            }
        });
        this.changePassButton.setText("Change Password...");
        this.changePassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordManagerDialog.this.changePassButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordManagerDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, 146, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.changePassButton, -1, -1, Short.MAX_VALUE).add((Component)this.addUserButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeUserButton, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add(118, 118, 118).add((Component)this.okButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(24, 24, 24).add((Component)this.addUserButton).addPreferredGap(0).add((Component)this.removeUserButton).addPreferredGap(0).add((Component)this.changePassButton))).addPreferredGap(0, 29, Short.MAX_VALUE).add((Component)this.okButton).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(this.passwordFile);
            out = new ObjectOutputStream(fos);
            out.writeObject(this.prop);
            out.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.setVisible(false);
    }

    private void changePassButtonActionPerformed(ActionEvent evt) {
        String user = (String)this.userList.getSelectedValue();
        UserPassDialog upd = new UserPassDialog(this.parent, user);
        upd.setVisible(true);
        int i = upd.getResponse();
        if (i == 389473) {
            char[] pass = upd.getPassword();
            try {
                byte[] hash = this.hash(user, pass);
                this.prop.put(user, hash);
                this.updateList();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        upd.dispose();
    }

    private void removeUserButtonActionPerformed(ActionEvent evt) {
        int option = JOptionPane.showConfirmDialog(this, "Are you sure you wish to remove " + this.userList.getSelectedValue() + "?", "Remove User", 0);
        if (option == 0) {
            this.prop.remove(this.userList.getSelectedValue());
            this.updateList();
        }
    }

    private void addUserButtonActionPerformed(ActionEvent evt) {
        UserPassDialog upd = new UserPassDialog(this.parent);
        upd.setVisible(true);
        int i = upd.getResponse();
        if (i == 389473) {
            char[] pass = upd.getPassword();
            String user = upd.getUsername();
            try {
                byte[] hash = this.hash(user, pass);
                this.prop.put(user, hash);
                this.updateList();
            }
            catch (NoSuchAlgorithmException nsae) {
                nsae.printStackTrace();
            }
        }
        upd.dispose();
    }

    private void userListValueChanged(ListSelectionEvent evt) {
    }

    private void openFile(File passwordFile) throws IOException {
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(passwordFile);
            in = new ObjectInputStream(fis);
            this.prop = (HashMap)in.readObject();
        }
        catch (IOException ioe) {
            this.prop = new HashMap<String, byte[]>();
        }
        catch (ClassNotFoundException ex) {
            this.prop = new HashMap<String, byte[]>();
        }
        this.updateList();
    }

    private void updateList() {
        this.users = this.prop.keySet().toArray();
        this.userList.setListData(this.users);
    }

    private byte[] hash(String user, char[] pass) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(user.getBytes());
        md.update(PasswordManagerDialog.getBytes(pass));
        byte[] digest = md.digest();
        return digest;
    }

    public byte[] getPassword(String user) {
        return this.prop.get(user);
    }

    private static byte[] getBytes(char[] ca) {
        byte[] ba = new byte[ca.length];
        for (int i = 0; i < ca.length; ++i) {
            ba[i] = (byte)ca[i];
        }
        return ba;
    }
}

