/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.gh_everyware_server.switchEditor;

import com.ghe.gh_everyware_server.DeviceManager;
import com.ghe.gh_everyware_server.IPServer;
import com.ghe.gh_everyware_server.switchEditor.SwitchEntryPanel;
import com.ghe.wio.Converter;
import com.ghe.wio.WioSwitchModel;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;

public class WioSwitchEditor
extends JFrame {
    SwitchEntryPanel[] panels;
    private int NUM_PANELS = 28;
    private DeviceManager manager;
    private File workingFile = null;
    private boolean changeDetected = false;
    private FileFilter xmlFilter = new XMLfilter();
    private ArrayList virtualSwitchArrayList = new ArrayList();
    private boolean virtualSwitch = false;
    private JRadioButton bandSwitchRadioButton;
    private JRadioButton buttonsRadioButton;
    private JPanel entryPanel;
    private JButton exitButton;
    private JMenuItem exitMenuItem;
    private JFileChooser fc;
    public ButtonGroup initailButtonGroup;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JRadioButton mapRadioButton;
    private JCheckBox matrixLockoutCheckbox;
    private JRadioButton onOffBankRadioButton;
    private JMenuItem openMenuItem;
    private JButton saveButton;
    private JMenuItem saveMenuItem;
    private ButtonGroup typeButtonGroup;
    private JTextField typeTextField;
    private JLabel virtualLabel;
    private JCheckBox virtualSwitchCheckbox;

    public WioSwitchEditor(DeviceManager manager) {
        this.manager = manager;
        this.initComponents();
        this.setResizable(true);
        this.setLocationRelativeTo(manager);
        this.panels = new SwitchEntryPanel[this.NUM_PANELS];
        for (int i = 0; i < this.NUM_PANELS; ++i) {
            SwitchEntryPanel p;
            this.panels[i] = p = new SwitchEntryPanel(this);
            this.entryPanel.add(this.panels[i]);
        }
        this.fc.setCurrentDirectory(new File(IPServer.getUserDirectory() + "wioProfiles/"));
        this.fc.setFileFilter(this.xmlFilter);
        this.pack();
        this.changeDetected = false;
        this.saveButton.setEnabled(false);
        this.jLabel9.setVisible(false);
    }

    public WioSwitchModel getModel() {
        WioSwitchModel model = new WioSwitchModel(this.typeTextField.getText());
        Map<String, int[]> switchingTable = Collections.synchronizedMap(new HashMap());
        boolean init = false;
        String initialValue = null;
        Vector<String> order = new Vector<String>();
        for (int i = 0; i < this.panels.length; ++i) {
            String posName = this.panels[i].getPositionName().trim();
            if (posName == null || "".equals(posName)) continue;
            order.add(posName);
            if (this.panels[i].isInitialSetting()) {
                initialValue = posName;
                init = true;
            }
            int[] stateArray = this.panels[i].getStateArray();
            switchingTable.put(posName, stateArray);
            model.setHeading(posName, this.panels[i].getHeading());
            model.setBeamwidth(posName, this.panels[i].getBeamwidth());
            model.setBidirectional(posName, this.panels[i].isBidirectional());
            model.setLowerFrequency(posName, this.panels[i].getLowerFreq());
            model.setUpperFrequency(posName, this.panels[i].getUpperFreq());
        }
        if (!init) {
            initialValue = this.panels[0].getPositionName();
        }
        model.setSwitchingTable(switchingTable);
        model.setOrderedPositionNames(order);
        if (this.mapRadioButton.isSelected()) {
            model.setDisplayType(2);
        } else if (this.buttonsRadioButton.isSelected()) {
            model.setDisplayType(1);
        } else if (this.bandSwitchRadioButton.isSelected()) {
            model.setDisplayType(3);
        } else if (this.onOffBankRadioButton.isSelected()) {
            model.setDisplayType(4);
        }
        if (this.matrixLockoutCheckbox.isSelected()) {
            model.setMatrixLockout(true);
        }
        if (this.virtualSwitchCheckbox.isSelected()) {
            model.setVirtualSwitch(true);
            model.setVirtualSwitches(this.virtualSwitchArrayList);
        }
        model.toXML();
        return model;
    }

    private void loadModel(WioSwitchModel model) {
        this.typeTextField.setText(model.getName());
        switch (model.getDisplayType()) {
            case 2: {
                this.mapRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.buttonsRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.bandSwitchRadioButton.setSelected(true);
                break;
            }
            case 4: {
                this.onOffBankRadioButton.setSelected(true);
            }
        }
        if (model.isMatrixLockout()) {
            this.matrixLockoutCheckbox.setSelected(true);
        }
        if (model.isVirtualSwitch()) {
            this.virtualSwitchCheckbox.setSelected(true);
            this.virtualSwitch = true;
        }
        Vector v = model.getPositionNames();
        Iterator itr = v.iterator();
        int c = 0;
        while (itr.hasNext()) {
            String pos = (String)itr.next();
            int[] stateArray = model.getMask(pos);
            int heading = model.getHeading(pos);
            int beamwidth = model.getBeamwidth(pos);
            boolean bidirectional = model.isBidirectional(pos);
            this.panels[c].setPositionNameField(pos);
            this.panels[c].setHeading(heading);
            this.panels[c].setBeamwidth(beamwidth);
            this.panels[c].setStateArray(stateArray);
            this.panels[c].setBidirectional(bidirectional);
            if (model instanceof WioSwitchModel) {
                WioSwitchModel m = model;
                this.panels[c].setLowerFreq(m.getLowerFreq(pos));
                this.panels[c].setUpperFreq(m.getUpperFreq(pos));
            }
            ++c;
        }
        for (int i = c; i < this.panels.length; ++i) {
            this.panels[i].setInitialSetting(false);
            this.panels[i].setPositionNameField(null);
            this.panels[i].setHeading(0);
            this.panels[i].setBeamwidth(0);
            this.panels[i].setStateArray(new int[]{-1, -1, -1, -1, -1, -1, -1, -1});
            this.panels[i].setBidirectional(false);
        }
        this.displayTypeActionPerformed(new ActionEvent(this, 2342, "blah"));
        this.changeDetected = false;
        this.saveButton.setEnabled(false);
        this.jLabel9.setVisible(false);
    }

    private void initComponents() {
        this.typeButtonGroup = new ButtonGroup();
        this.initailButtonGroup = new ButtonGroup();
        this.fc = new JFileChooser();
        this.typeTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.entryPanel = new JPanel();
        this.saveButton = new JButton();
        this.jPanel1 = new JPanel();
        this.buttonsRadioButton = new JRadioButton();
        this.mapRadioButton = new JRadioButton();
        this.bandSwitchRadioButton = new JRadioButton();
        this.onOffBankRadioButton = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel11 = new JLabel();
        this.virtualLabel = new JLabel();
        this.matrixLockoutCheckbox = new JCheckBox();
        this.virtualSwitchCheckbox = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.exitButton = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.fc.setCurrentDirectory(new File("C:\\Program Files\\NetBeans 8.2\\.\\..\\wioProfiles"));
        this.setDefaultCloseOperation(0);
        this.setTitle("Wio Profile Editor");
        this.setIconImage(IPServer.IMAGE_ICON.getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WioSwitchEditor.this.formWindowClosing(evt);
            }
        });
        this.typeTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WioSwitchEditor.this.typeTextFieldActionPerformed(evt);
            }
        });
        this.typeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                WioSwitchEditor.this.typeTextFieldKeyTyped(evt);
            }
        });
        this.jLabel1.setText("Device Type:");
        this.entryPanel.setLayout(new GridLayout(this.NUM_PANELS, 1, 0, 1));
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WioSwitchEditor.this.saveButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Display Type"));
        this.jPanel1.setMinimumSize(new Dimension(350, 56));
        this.jPanel1.setPreferredSize(new Dimension(350, 56));
        this.jPanel1.setVerifyInputWhenFocusTarget(false);
        this.typeButtonGroup.add(this.buttonsRadioButton);
        this.buttonsRadioButton.setSelected(true);
        this.buttonsRadioButton.setText("Buttons");
        this.buttonsRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WioSwitchEditor.this.radioButtonStateChange(evt);
            }
        });
        this.buttonsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WioSwitchEditor.this.displayTypeActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.buttonsRadioButton);
        this.typeButtonGroup.add(this.mapRadioButton);
        this.mapRadioButton.setText("Map");
        this.mapRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WioSwitchEditor.this.radioButtonStateChange(evt);
            }
        });
        this.mapRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WioSwitchEditor.this.displayTypeActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.mapRadioButton);
        this.typeButtonGroup.add(this.bandSwitchRadioButton);
        this.bandSwitchRadioButton.setText("Band Switch");
        this.bandSwitchRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WioSwitchEditor.this.displayTypeActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.bandSwitchRadioButton);
        this.typeButtonGroup.add(this.onOffBankRadioButton);
        this.onOffBankRadioButton.setText("On/Off Bank");
        this.onOffBankRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WioSwitchEditor.this.displayTypeActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.onOffBankRadioButton);
        this.jLabel4.setText("Name of Setting");
        this.jLabel8.setText("Bidirectional");
        this.jLabel6.setText("Degrees");
        this.jLabel7.setText("Beamwidth");
        this.jLabel2.setText("     1               2               3               4               5               6              7               8");
        this.jLabel3.setText("Lower");
        this.jLabel10.setText("Upper");
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("Freq. (MHz)");
        this.jLabel11.setHorizontalAlignment(0);
        this.jLabel11.setText("Outputs");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.virtualLabel, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel4, -1, 91, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel8, -1, 87, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6, -1, 54, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7, -1, 61, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel11, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addGap(66, 66, 66).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3, -1, 48, Short.MAX_VALUE).addGap(26, 26, 26).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE).addGap(21, 21, 21)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel5, -1, 91, Short.MAX_VALUE).addGap(33, 33, 33)))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 9, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel8, -2, 30, -2).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.jLabel2).addComponent(this.jLabel10).addComponent(this.jLabel3).addComponent(this.virtualLabel))).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jLabel5)).addContainerGap(25, Short.MAX_VALUE)))));
        this.matrixLockoutCheckbox.setText("Matrix Lockout");
        this.matrixLockoutCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WioSwitchEditor.this.matrixLockoutCheckboxItemStateChanged(evt);
            }
        });
        this.virtualSwitchCheckbox.setText("Virtual Switch");
        this.virtualSwitchCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WioSwitchEditor.this.virtualSwitchCheckboxItemStateChanged(evt);
            }
        });
        this.jLabel9.setText("Keep Editor Open");
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WioSwitchEditor.this.exitButtonActionPerformed(evt);
            }
        });
        this.jMenu1.setText("File");
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WioSwitchEditor.this.openMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.openMenuItem);
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WioSwitchEditor.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.saveMenuItem);
        this.jMenu1.add(this.jSeparator1);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WioSwitchEditor.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exitMenuItem);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addGap(62, 62, 62).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.matrixLockoutCheckbox).addGap(129, 129, 129)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.virtualSwitchCheckbox, -1, -1, Short.MAX_VALUE).addComponent(this.typeTextField, -1, 115, Short.MAX_VALUE))).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addComponent(this.entryPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(266, 266, 266).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel9).addGap(152, 152, 152).addComponent(this.exitButton).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.typeTextField, -2, -1, -2)).addGap(6, 6, 6).addComponent(this.matrixLockoutCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.virtualSwitchCheckbox))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.entryPanel, -2, 587, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveButton).addComponent(this.jLabel9).addComponent(this.exitButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMenuItemActionPerformed(ActionEvent evt) {
        String s = this.typeTextField.getText();
        FileOutputStream fis = null;
        try {
            this.fc.setSelectedFile(new File(s + ".xml"));
            int option = this.fc.showSaveDialog(this);
            if (option != 0) {
                return;
            }
            fis = new FileOutputStream(this.fc.getSelectedFile());
            fis.write(this.getModel().toXML().getBytes());
            this.manager.updateWioTypes();
        }
        catch (IOException ex) {
            Logger.getLogger(WioSwitchEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(WioSwitchEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.changeDetected = false;
        this.saveButton.setEnabled(false);
        this.jLabel9.setVisible(false);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        int option;
        if (this.changeDetected) {
            option = JOptionPane.showConfirmDialog(this, "Would you like to save your changes?", "Open", 1);
            if (option == 0) {
                this.saveMenuItemActionPerformed(new ActionEvent(this, 2342343, "Open"));
            } else if (option == 2) {
                return;
            }
        }
        if ((option = this.fc.showOpenDialog(this)) == 0) {
            try {
                WioSwitchModel model = (WioSwitchModel)Converter.getWIOSwitchModel(this.fc.getSelectedFile());
                this.loadModel(model);
                if (model.isVirtualSwitch()) {
                    this.virtualSwitchArrayList = model.getVirtualSwitches();
                }
                this.setTitle("Wio Profile Editor -- " + this.fc.getSelectedFile().getName());
                this.workingFile = this.fc.getSelectedFile();
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(WioSwitchEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(WioSwitchEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public boolean isVirtualSwitch() {
        return this.virtualSwitch;
    }

    public ArrayList getVirtualList() {
        return this.virtualSwitchArrayList;
    }

    public void setVirtualList(ArrayList vs) {
        this.virtualSwitchArrayList = vs;
    }

    public void replaceVirtualListElements(String oldName, String newName) {
        ArrayList<String[]> tempSwitchArrayList = new ArrayList<String[]>();
        Iterator itr = this.virtualSwitchArrayList.iterator();
        while (itr.hasNext()) {
            String[] strArrayOld = new String[3];
            String[] strArrayNew = new String[3];
            strArrayOld = (String[])itr.next();
            if (strArrayOld[0].equals(oldName)) {
                strArrayNew[0] = newName;
                strArrayNew[1] = strArrayOld[1];
                strArrayNew[2] = strArrayOld[2];
                tempSwitchArrayList.add(strArrayNew);
                continue;
            }
            tempSwitchArrayList.add(strArrayOld);
        }
        this.setVirtualList(tempSwitchArrayList);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.exitEditor();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        if (this.changeDetected) {
            int option = JOptionPane.showConfirmDialog(this, "Do you wish to save the change to this profile?", "Done", 1);
            if (option == 0) {
                this.saveMenuItemActionPerformed(new ActionEvent(this, 1283721, "EXIT_SAVE"));
            } else {
                if (option == 2) {
                    return;
                }
                if (option == 1) {
                    this.ReloadCurrentForm();
                }
            }
        }
    }

    private void radioButtonStateChange(ItemEvent evt) {
        this.propertyChange();
    }

    private void typeTextFieldKeyTyped(KeyEvent evt) {
        this.propertyChange();
    }

    private void ReloadCurrentForm() {
        try {
            WioSwitchModel model = (WioSwitchModel)Converter.getWIOSwitchModel(this.workingFile);
            this.loadModel(model);
            if (model.isVirtualSwitch()) {
                this.virtualSwitchArrayList = model.getVirtualSwitches();
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(WioSwitchEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(WioSwitchEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exitEditor();
    }

    private void displayTypeActionPerformed(ActionEvent evt) {
        int i;
        if (this.mapRadioButton.isSelected()) {
            for (i = 0; i < this.panels.length; ++i) {
                this.panels[i].allowHeadings(true);
            }
        } else {
            for (i = 0; i < this.panels.length; ++i) {
                this.panels[i].allowHeadings(false);
            }
        }
        if (this.bandSwitchRadioButton.isSelected()) {
            for (i = 0; i < this.panels.length; ++i) {
                this.panels[i].allowFrequency(true);
            }
        } else {
            for (i = 0; i < this.panels.length; ++i) {
                this.panels[i].allowFrequency(false);
            }
        }
        if (this.mapRadioButton.isSelected() || this.onOffBankRadioButton.isSelected()) {
            this.matrixLockoutCheckbox.setEnabled(false);
        } else {
            this.matrixLockoutCheckbox.setEnabled(true);
        }
        if (this.onOffBankRadioButton.isSelected()) {
            this.virtualSwitchCheckbox.setEnabled(false);
        } else {
            this.virtualSwitchCheckbox.setEnabled(true);
        }
    }

    private void matrixLockoutCheckboxItemStateChanged(ItemEvent evt) {
        this.changeDetected = true;
        this.saveButton.setEnabled(true);
        this.jLabel9.setVisible(true);
    }

    private void virtualSwitchCheckboxItemStateChanged(ItemEvent evt) {
        this.changeDetected = true;
        this.saveButton.setEnabled(true);
        this.jLabel9.setVisible(true);
        if (this.virtualSwitchCheckbox.isSelected()) {
            for (int i = 0; i < this.panels.length; ++i) {
                this.panels[i].allowVirtualPositions(true);
                this.panels[i].allowSwitchCheckPanel(false);
                this.onOffBankRadioButton.setEnabled(false);
                this.virtualLabel.setText("Virtual");
            }
        } else {
            for (int i = 0; i < this.panels.length; ++i) {
                this.panels[i].allowVirtualPositions(false);
                this.panels[i].allowSwitchCheckPanel(true);
                this.onOffBankRadioButton.setEnabled(true);
                this.virtualLabel.setText("  ");
            }
        }
    }

    private void typeTextFieldActionPerformed(ActionEvent evt) {
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        this.exitEditor();
    }

    private void exitEditor() {
        if (this.changeDetected) {
            int option = JOptionPane.showConfirmDialog(this, "Do you wish to save this profile before exiting?", "Close editor", 1);
            if (option == 0) {
                this.saveMenuItemActionPerformed(new ActionEvent(this, 1283721, "EXIT_SAVE"));
                this.dispose();
            } else {
                if (option == 2) {
                    return;
                }
                if (option == 1) {
                    JOptionPane.showMessageDialog(this, "You will need to disconnect and reconnect any \ndevices you have changed during this editing session.");
                    this.dispose();
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "You will need to disconnect and reconnect any \ndevices that you have changed during this editing session.");
            this.dispose();
        }
    }

    public void propertyChange() {
        this.changeDetected = true;
        this.saveButton.setEnabled(true);
        this.jLabel9.setVisible(true);
    }

    class XMLfilter
    extends FileFilter {
        XMLfilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
        }

        @Override
        public String getDescription() {
            return "XML Files";
        }
    }
}

