/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.rotor;

import com.ghe.event.RotorCommandListener;
import com.ghe.event.RotorEventController;
import com.ghe.event.RotorQueryListener;
import com.ghe.event.RotorStopListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public abstract class SerialRotor
extends RotorEventController
implements RotorCommandListener,
RotorQueryListener,
RotorStopListener,
SerialPortEventListener {
    private Enumeration portList;
    private CommPortIdentifier portId;
    protected SerialPort serialPort;
    protected OutputStream outputStream;
    protected InputStream inputStream;
    private boolean portOpen = false;
    private boolean portBusy = false;
    private String name;
    private int baudrate = 4800;
    private int flowControl = 0;
    protected int dataBits = 8;
    private int parity = 0;
    private int stopBits = 1;

    public void openConnection(String port) throws IOException, TooManyListenersException, UnsupportedCommOperationException, NoSuchPortException, PortInUseException {
        this.portId = CommPortIdentifier.getPortIdentifier((String)port);
        this.serialPort = (SerialPort)this.portId.open(port, 2000);
        this.portOpen = true;
        this.outputStream = this.serialPort.getOutputStream();
        this.inputStream = this.serialPort.getInputStream();
        this.serialPort.setSerialPortParams(this.baudrate, this.dataBits, this.stopBits, this.parity);
        this.serialPort.setFlowControlMode(0);
        this.serialPort.addEventListener((SerialPortEventListener)this);
        this.serialPort.notifyOnDataAvailable(true);
        this.serialPort.enableReceiveTimeout(1000);
    }

    public void closeConnection() throws IOException {
        if (!this.portOpen) {
            return;
        }
        this.outputStream.close();
        this.inputStream.close();
        this.portOpen = false;
        if (this.serialPort != null) {
            this.serialPort.close();
        }
    }

    public boolean isPortOpen() {
        return this.portOpen;
    }

    private synchronized void sendToRotor(char[] c) throws IOException {
        for (int i = 0; i < c.length; ++i) {
            this.outputStream.write((byte)c[i]);
        }
        this.outputStream.flush();
    }

    public void sendToRotor(String str) throws IOException {
        this.sendToRotor(str.toCharArray());
    }

    public abstract void queryPosition() throws IOException;

    public void setBaudRate(int baudrate) {
        this.baudrate = baudrate;
    }

    public void setFlowControl(int flowControl) {
        this.flowControl = flowControl;
    }

    public void setParity(int parity) {
        this.parity = parity;
    }

    public void setStopBits(int stopBits) {
        this.stopBits = stopBits;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getPortName() {
        return this.serialPort.getName();
    }
}

