/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.wio;

import com.ghe.wio.IWioRotor;
import com.ghe.wio.LogicalDevice;
import com.ghe.wio.WioBase;
import com.ghe.wio.WioDataListener;
import com.ghe.wio.WioRotor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WioPhysicalRemote
implements WioDataListener {
    public static final int PIN_DONT_CARE = -1;
    public static final int PIN_OFF = 0;
    public static final int PIN_ON = 1;
    public static final int PIN_MOMENTARY_ON = 2;
    public static final int PIN_DI = 3;
    public static final int PIN_AI = 4;
    public static final int PIN_TEMP_SENSOR = 5;
    public static final byte API_REMOTE_COMMAND = 23;
    public static final byte API_AT_RESPONSE = -105;
    public static final int STATUS_UNKNOWN = -1;
    public static final int STATUS_GOOD = 0;
    public static final int STATUS_ERROR = 1;
    public static final int STATUS_INVALID_COMMAND = 2;
    public static final int STATUS_INVALD_PARAMETER = 3;
    public static final int STATUS_NO_RESPONSE = 4;
    private volatile int status = 4;
    public final int address;
    private final WioBase wioBase;
    private volatile boolean[] currentState = new boolean[8];
    private IWioRotor rotor = null;
    private boolean bit7;
    private byte id = 1;
    private int remoteRSSI = 0;
    private int rssiCounter = 0;
    private int commandNRCounter = 0;
    private int pollNRCounter = 0;
    private PollThread pollThread;
    private final Set<LogicalDevice> logicalDevices;
    private final Object stateLock = new Object();
    private final String wioHardwareType;
    private final Object lock = new Object();

    public WioPhysicalRemote(WioBase wioBase, int address, String wioHardwareType) {
        this.logicalDevices = Collections.synchronizedSet(new HashSet());
        this.wioBase = wioBase;
        this.address = address;
        this.wioHardwareType = wioHardwareType;
    }

    public int getAddress() {
        return this.address;
    }

    protected void notifyLogicalDevices() {
        for (LogicalDevice l : this.logicalDevices) {
            l.physicalStatusChanged(this.currentState, this.status, this.remoteRSSI);
        }
    }

    @Override
    public void processData(byte[] wioPacket) {
        if (wioPacket[3] == -120) {
            this.status = wioPacket[7];
            this.remoteRSSI = 0;
            if (this.status == 4 && this.address != 0) {
                ++this.commandNRCounter;
                if (this.commandNRCounter > 10) {
                    this.notifyLogicalDevices();
                }
            } else {
                this.commandNRCounter = 0;
                this.notifyLogicalDevices();
            }
        } else if (wioPacket[3] == -127) {
            if (this.rotor != null) {
                this.rotor.processData(wioPacket);
            }
        } else {
            this.status = wioPacket[17];
            if (wioPacket[15] == 68 && wioPacket[16] == 66) {
                if (-wioPacket[18] < 0) {
                    this.remoteRSSI = -wioPacket[18];
                }
                if (this.status == 4 && this.address != 0) {
                    ++this.pollNRCounter;
                    if (this.pollNRCounter > 10) {
                        this.notifyLogicalDevices();
                    }
                } else {
                    this.pollNRCounter = 0;
                    this.notifyLogicalDevices();
                }
            } else if (this.status == 4) {
                ++this.commandNRCounter;
                if (this.commandNRCounter > 10) {
                    this.notifyLogicalDevices();
                }
            } else {
                this.commandNRCounter = 0;
                this.notifyLogicalDevices();
            }
        }
    }

    @Override
    public void close() {
        if (this.pollThread != null) {
            this.pollThread.kill();
        }
        this.wioBase.wioPhysicalRemoteClosed(this);
    }

    public IWioRotor getRotor() {
        return this.rotor;
    }

    public void addRotor(WioRotor rotor) {
        this.rotor = rotor;
        if (this.pollThread == null || !this.pollThread.isAlive()) {
            this.pollThread = new PollThread(this);
            this.pollThread.start();
        }
    }

    public void removeRotor(WioRotor rotor) {
        this.rotor = null;
        if (this.logicalDevices.size() == 0 && this.rotor == null) {
            if (this.pollThread != null && this.pollThread.isAlive()) {
                this.pollThread.kill();
            }
            this.close();
        }
    }

    void addLogicalDevice(LogicalDevice d) {
        this.logicalDevices.add(d);
        if (this.pollThread == null || !this.pollThread.isAlive()) {
            this.pollThread = new PollThread(this);
            this.pollThread.start();
        }
    }

    void removeLogicalDevice(LogicalDevice d) {
        this.logicalDevices.remove(d);
        if (this.logicalDevices.size() == 0 && this.rotor == null) {
            this.pollThread.kill();
            this.close();
        }
    }

    void sendData(byte[] pdu) throws IOException {
        this.wioBase.sendData(pdu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void requestSwitch(int[] states) {
        Object object = this.stateLock;
        synchronized (object) {
            boolean[] newArrayState = Arrays.copyOf(this.currentState, this.currentState.length);
            int[] fallbackStates = Arrays.copyOf(states, states.length);
            for (int i = 0; i < fallbackStates.length; ++i) {
                if (fallbackStates[i] != 2) continue;
                fallbackStates[i] = 0;
            }
            boolean momentary = false;
            block13: for (int i = 0; i < states.length; ++i) {
                switch (states[i]) {
                    case -1: {
                        continue block13;
                    }
                    case 0: {
                        newArrayState[i] = false;
                        continue block13;
                    }
                    case 1: {
                        newArrayState[i] = true;
                        continue block13;
                    }
                    case 2: {
                        newArrayState[i] = true;
                        momentary = true;
                    }
                }
            }
            byte b = WioPhysicalRemote.getRelayByte(newArrayState);
            byte[] pdu = this.createRelaySetPDURemote(b);
            try {
                this.sendData(pdu);
                this.currentState = newArrayState;
                if (momentary) {
                    Thread.sleep(500L);
                    this.requestSwitch(fallbackStates);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(WioPhysicalRemote.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(WioPhysicalRemote.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void initializeSwitch(int[] states) {
        Object object = this.stateLock;
        synchronized (object) {
            boolean[] newArrayState = Arrays.copyOf(this.currentState, this.currentState.length);
            block8: for (int i = 0; i < states.length; ++i) {
                switch (states[i]) {
                    case -1: {
                        continue block8;
                    }
                    case 0: {
                        newArrayState[i] = false;
                        continue block8;
                    }
                    case 1: {
                        newArrayState[i] = true;
                        continue block8;
                    }
                }
            }
            this.currentState = newArrayState;
        }
    }

    private byte[] createRelaySetPDURemote(byte state) {
        byte[] rVal;
        this.id = (byte)(this.id + 1);
        this.id = (byte)(this.id % 10);
        if (this.address == 0) {
            rVal = this.createRelaySetPDULocal(state);
        } else {
            byte[] b = new byte[]{126, 0, 16, 23, this.id, 0, 0, 0, 0, 0, 0, 0, 0, 16, (byte)this.address, 2, 73, 79, state, 0};
            rVal = WioPhysicalRemote.check(b);
        }
        return rVal;
    }

    private static byte getRelayByte(boolean[] states) {
        byte rVal = 0;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            rVal = (byte)((double)rVal + Math.pow(2.0, i));
        }
        return rVal;
    }

    private byte[] createRelaySetPDULocal(byte state) {
        byte[] b = new byte[]{126, 0, 5, 8, this.id, 73, 79, state, 0};
        byte[] rVal = WioPhysicalRemote.check(b);
        return rVal;
    }

    static byte[] check(byte[] pdu) {
        byte check;
        int sum = 0;
        for (int i = 3; i < pdu.length - 1; ++i) {
            sum += pdu[i];
        }
        pdu[pdu.length - 1] = check = (byte)(255 - sum);
        return pdu;
    }

    private byte[] createRemoteRSSIQueryPDU() {
        byte[] b = new byte[]{126, 0, 15, 23, this.id, 0, 0, 0, 0, 0, 0, 0, 0, 16, (byte)this.address, 2, 68, 66, 0};
        byte[] rVal = WioPhysicalRemote.check(b);
        return rVal;
    }

    public void queryRemoteRSSI() {
        try {
            byte[] pdu = this.createRemoteRSSIQueryPDU();
            this.sendData(pdu);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public WioBase getWioBase() {
        return this.wioBase;
    }

    class PollThread
    extends Thread {
        private volatile boolean kill = false;
        private final Object owner;

        PollThread(Object owner) {
            this.owner = owner;
        }

        public void kill() {
            this.kill = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(WioPhysicalRemote.class.getName()).log(Level.SEVERE, null, ex);
            }
            while (!this.kill) {
                try {
                    Object ex = WioPhysicalRemote.this.stateLock;
                    synchronized (ex) {
                        byte b = WioPhysicalRemote.getRelayByte(WioPhysicalRemote.this.currentState);
                        if (WioPhysicalRemote.this.wioHardwareType.equals("wio6")) {
                            if (WioPhysicalRemote.this.bit7) {
                                b = (byte)(b + 128 & 0xFF);
                            }
                            WioPhysicalRemote.this.bit7 = !WioPhysicalRemote.this.bit7;
                        }
                        byte[] pdu = WioPhysicalRemote.this.createRelaySetPDURemote(b);
                        WioPhysicalRemote.this.sendData(pdu);
                    }
                    if (WioPhysicalRemote.this.address != 0 && WioPhysicalRemote.this.status == 0 && WioPhysicalRemote.this.rssiCounter % 5 == 0) {
                        Thread.sleep(400L);
                        ex = this.owner;
                        synchronized (ex) {
                            WioPhysicalRemote.this.queryRemoteRSSI();
                        }
                        Thread.sleep(400L);
                    } else {
                        Thread.sleep(800L);
                    }
                    WioPhysicalRemote.this.rssiCounter++;
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

