/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.wio;

import com.ghe.event.EEUpdateEvent;
import com.ghe.event.RotorCommandEvent;
import com.ghe.event.RotorEvent;
import com.ghe.event.RotorQueryEvent;
import com.ghe.event.RotorStopEvent;
import com.ghe.rotor.SerialRotor;
import com.ghe.wio.IWioRotor;
import com.ghe.wio.LogicalDevice;
import com.ghe.wio.WioBase;
import com.ghe.wio.WioPhysicalRemote;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.comm.SerialPortEvent;

public class WioRotor
extends SerialRotor
implements IWioRotor,
LogicalDevice {
    public static final String ACK = "\u0006";
    public static final String SOH = "\u0001";
    private final int address;
    private byte id = 0;
    private final PollThread pollThread;
    private volatile double currentHeading = 0.0;
    private WioPhysicalRemote phyRemote;
    private boolean open = false;
    private int model = 478342934;
    private static DecimalFormat df_rt21 = new DecimalFormat("000.0");
    private static DecimalFormat df_rt20 = new DecimalFormat("000");
    private volatile boolean responseReceived = true;
    private volatile int remoteRSSI;
    private byte lastSentID = 0;
    private boolean bit7 = true;

    public WioRotor(int address, WioPhysicalRemote physicalRemote, int model) throws Exception {
        this.address = address;
        this.phyRemote = physicalRemote;
        physicalRemote.addRotor(this);
        this.model = model;
        this.pollThread = new PollThread(this);
        this.pollThread.start();
        this.open = true;
    }

    @Override
    public boolean isPortOpen() {
        return this.open;
    }

    @Override
    public void closeConnection() throws IOException {
        System.out.println("+WioRotor:closeConnection()");
        this.phyRemote.removeRotor(this);
        this.open = false;
    }

    @Override
    public void sendToRotor(String s) throws IOException {
        byte[] pdu = this.createPDU(s);
        this.phyRemote.sendData(pdu);
    }

    @Override
    public void turn(double heading) {
        try {
            if (heading == RotorCommandEvent.TURN_CCW) {
                if (this.model == 9374738) {
                    this.sendToRotor("AA0;");
                }
            } else if (heading == RotorCommandEvent.TURN_CW) {
                if (this.model == 9374738) {
                    this.sendToRotor("AB0;");
                }
            } else {
                String commandString;
                if (this.model == 9374738) {
                    String headingString = df_rt21.format(heading);
                    commandString = "AP2" + headingString + '\r' + ";";
                } else {
                    String headingString = df_rt20.format(heading);
                    commandString = "AP2" + headingString + '\r' + ";";
                }
                try {
                    this.sendToRotor(commandString);
                    Thread.sleep(500L);
                    this.sendToRotor(commandString);
                    Thread.sleep(500L);
                    this.sendToRotor(commandString);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        try {
            this.sendToRotor(";");
            Thread.sleep(500L);
            this.sendToRotor(";");
            Thread.sleep(500L);
            this.sendToRotor(";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public double getHeading() {
        return this.currentHeading;
    }

    private byte[] createPDU(String command) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] pre = new byte[]{126, 0, 0, 1, this.id, 16, (byte)this.address, 0};
        bos.write(pre);
        byte[] commandBytes = command.getBytes();
        bos.write(commandBytes);
        bos.write(0);
        byte[] formatted = bos.toByteArray();
        byte[] rVal = WioRotor.check(formatted);
        this.lastSentID = this.id;
        this.id = (byte)((this.id + 1) % 10);
        return rVal;
    }

    static byte[] check(byte[] pdu) {
        byte check;
        int sum = 0;
        for (int i = 3; i < pdu.length - 1; ++i) {
            sum += pdu[i];
        }
        pdu[pdu.length - 1] = check = (byte)(255 - sum);
        pdu[2] = (byte)(pdu.length - 4);
        return pdu;
    }

    private void processDataString(String dataString) {
        if (dataString.contains(ACK)) {
            if (dataString.charAt(dataString.length() - 2) == '\u0006') {
                dataString = "";
            } else if (dataString.charAt(dataString.length() - 3) == '\u0006') {
                char eeRegister = dataString.charAt(dataString.length() - 2);
                dataString = "";
            }
        } else if (dataString.contains(SOH)) {
            char eeRegister = dataString.charAt(dataString.indexOf(SOH) - 1);
            String value = dataString.substring(dataString.indexOf(SOH) + 1, dataString.length() - 1);
            this.fireEEUpdateEvent(new EEUpdateEvent(this, eeRegister, value));
        } else if (dataString.contains(".")) {
            String[] strs;
            if (dataString.length() > 1 && (strs = dataString.split(";")).length > 0 && strs[strs.length - 1].length() > 0) {
                double d;
                this.currentHeading = d = Double.parseDouble(strs[strs.length - 1].substring(0, strs[strs.length - 1].length()));
                this.responseReceived = true;
                this.fireRotorEvent(new RotorEvent(this, d, RotorEvent.STATUS_OK, this.remoteRSSI));
            }
        } else if (dataString.length() > 3) {
            dataString = dataString.replaceAll(";", " ");
            dataString = dataString.substring(dataString.length() - 4);
            this.responseReceived = true;
            this.currentHeading = Double.parseDouble(dataString);
            this.fireRotorEvent(new RotorEvent(this, Double.parseDouble(dataString), RotorEvent.STATUS_OK, this.remoteRSSI));
        }
    }

    public void serialEvent(SerialPortEvent event) {
    }

    @Override
    public void queryPosition() throws IOException {
        this.getHeading();
    }

    @Override
    public void rotorCommandOccurred(RotorCommandEvent evt) {
        if (this.getName().equals(evt.getRotor())) {
            this.turn(evt.getHeading());
        }
    }

    @Override
    public void rotorQueryOccurred(RotorQueryEvent evt) {
        if (this.getName().equals(evt.getRotor())) {
            this.getHeading();
        }
    }

    @Override
    public void rotorStopEventOccurred(RotorStopEvent evt) {
        if (this.getName().equals(evt.getRotor())) {
            this.stop();
        }
    }

    @Override
    public void processData(byte[] wioPacket) {
        byte[] data = Arrays.copyOfRange(wioPacket, 8, wioPacket.length - 1);
        String dataString = new String(data);
        this.remoteRSSI = -wioPacket[6];
        this.processDataString(dataString);
    }

    public WioBase getWioBase() {
        return this.phyRemote.getWioBase();
    }

    static void printArray(byte[] b) {
        String s = "";
        for (int i = 0; i < b.length; ++i) {
            s = s + Integer.toHexString(b[i]) + " ";
        }
    }

    @Override
    public void physicalStatusChanged(boolean[] currentState, int status, int remoteRSSI) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    class PollThread
    extends Thread {
        private volatile boolean kill = false;
        private final WioRotor owner;
        private int failedResponseCounter = 0;

        PollThread(WioRotor owner) {
            this.owner = owner;
        }

        public void kill() {
            this.kill = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.kill) {
                try {
                    this.failedResponseCounter = !WioRotor.this.responseReceived ? ++this.failedResponseCounter : 0;
                    if (this.failedResponseCounter > 5) {
                        this.owner.fireRotorEvent(new RotorEvent(this.owner, this.owner.currentHeading, RotorEvent.STATUS_ERROR, 0));
                    }
                    WioRotor.this.responseReceived = false;
                    WioRotor wioRotor = this.owner;
                    synchronized (wioRotor) {
                        if (WioRotor.this.model == 9374738) {
                            WioRotor.this.sendToRotor("BI2;");
                        } else {
                            WioRotor.this.sendToRotor("AI2;");
                        }
                    }
                    Thread.sleep(400L);
                    Thread.sleep(400L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.kill();
                }
            }
        }
    }
}

