/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.gh_everyware_server;

import com.ghe.gh_everyware_server.IPServer;
import com.ghe.gh_everyware_server.ServerSerialRotor;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.layout.GroupLayout;

public class MonitorWindow
extends JFrame {
    private static final char NAK = '\u0015';
    private static final char ACK = '\u0006';
    private static final char SOH = '\u0001';
    private boolean connectedState = false;
    private int errorCounter = 0;
    private int sentCounter = 0;
    private ServerSerialRotor rotor;
    private JButton closeButton;
    private JLabel closeToLimitLabel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JScrollPane rxScrollPane;
    private JTextArea rxTextArea;
    private JLabel tooCloseToLimitLabel;
    private JScrollPane txScrollPane;
    private JTextArea txTextArea;

    public MonitorWindow(Frame parent) {
        this.setLocationRelativeTo(parent);
        this.initComponents();
        if (IPServer.IMAGE_ICON != null) {
            this.setIconImage(IPServer.IMAGE_ICON.getImage());
        }
    }

    private void initComponents() {
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.closeToLimitLabel = new JLabel();
        this.tooCloseToLimitLabel = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.txScrollPane = new JScrollPane();
        this.txTextArea = new JTextArea();
        this.rxScrollPane = new JScrollPane();
        this.rxTextArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.closeButton = new JButton();
        this.jLabel10.setText("Close To Limit:");
        this.jLabel11.setText("Too Close To Limit:");
        this.closeToLimitLabel.setHorizontalAlignment(11);
        this.closeToLimitLabel.setText("--");
        this.tooCloseToLimitLabel.setHorizontalAlignment(11);
        this.tooCloseToLimitLabel.setText("--");
        this.jLabel19.setText("deg");
        this.jLabel20.setText("deg");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MonitorWindow.this.formWindowClosing(evt);
            }
        });
        this.txTextArea.setColumns(20);
        this.txTextArea.setRows(5);
        this.txScrollPane.setViewportView(this.txTextArea);
        this.rxTextArea.setColumns(20);
        this.rxTextArea.setRows(5);
        this.rxScrollPane.setViewportView(this.rxTextArea);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Sent to Rotor");
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Received from Rotor");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorWindow.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.txScrollPane, -2, 191, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(154, 154, 154).add((Component)this.jLabel2).addPreferredGap(0, -1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.rxScrollPane, -2, 192, -2).add(25, 25, 25)))).add((GroupLayout.Group)layout.createSequentialGroup().add(196, 196, 196).add((Component)this.closeButton, -2, 75, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.txScrollPane, -1, 221, Short.MAX_VALUE).add((Component)this.rxScrollPane, -1, 221, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.closeButton)));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        if (this.rotor != null) {
            this.setVisible(false);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.rotor != null) {
            this.setVisible(false);
        }
    }

    public void displaySentText(String str) {
        if (this.txTextArea.getLineCount() > 500) {
            this.txTextArea.setText("");
        }
        String s = str.replaceAll("\u0001", "<SOH>");
        s = s.replaceAll("\u0006", "<ACK>");
        s = s.replaceAll("\u0015", "<NAK>");
        this.txTextArea.append(s + '\n');
        this.txTextArea.setCaretPosition(this.txTextArea.getDocument().getLength());
    }

    public void displayReceivedText(String str) {
        if (this.rxTextArea.getLineCount() > 500) {
            this.rxTextArea.setText("");
        }
        String s = str.replaceAll("\u0001", "<SOH>");
        s = s.replaceAll("\u0006", "<ACK>");
        s = s.replaceAll("\u0015", "<NAK>");
        this.rxTextArea.append(s + '\n');
        this.rxTextArea.setCaretPosition(this.rxTextArea.getDocument().getLength());
    }

    public void setRotor(ServerSerialRotor rotor) {
        this.rotor = rotor;
        this.setTitle(rotor.getName());
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    void setConnected(boolean b) {
        this.connectedState = b;
    }
}

