/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.gh_everyware_server;

import com.ghe.gh_everyware_server.PresetsTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jdesktop.layout.GroupLayout;

public class PresetsEditor
extends JDialog
implements TableModelListener {
    public static final int SAVE_OPTION = 2;
    public static final int CANCEL_OPTION = 0;
    private int returnValue;
    private File file;
    private PresetsTableModel presetsTableModel;
    private JTable presetsTable;
    private JButton addEntryButton;
    private JPanel bottomPanel;
    private JButton cancelButton;
    private JButton deleteEntryButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JButton saveButton;
    private JScrollPane scrollPane;
    private JPanel topPanel;

    public PresetsEditor(Frame owner, File file) {
        super(owner, false);
        this.setLocationRelativeTo(owner);
        this.file = file;
        this.presetsTableModel = new PresetsTableModel(file);
        this.presetsTable = new JTable(this.presetsTableModel);
        if (this.presetsTable.getCellEditor() instanceof DefaultCellEditor) {
            DefaultCellEditor ed = (DefaultCellEditor)this.presetsTable.getCellEditor();
            ed.setClickCountToStart(1);
        }
        this.presetsTable.setSelectionMode(0);
        this.presetsTable.setRowSelectionAllowed(false);
        this.initComponents();
        this.validate();
        this.pack();
    }

    private void initComponents() {
        this.bottomPanel = new JPanel();
        this.saveButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.scrollPane = new JScrollPane(this.presetsTable);
        this.topPanel = new JPanel();
        this.addEntryButton = new JButton();
        this.deleteEntryButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Preset Locations");
        this.setResizable(false);
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PresetsEditor.this.saveButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PresetsEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Enter South and East as negative (-).");
        this.jLabel2.setText("Double-click a cell to edit a value, press Enter to store changes.");
        this.jLabel3.setText("Press \"Save\" to save changes or \"Cancel\" to erase all changes.");
        this.jLabel4.setText("Enter all values in decimal format:  nnn.nnn");
        this.jLabel5.setText("Saving changes will automatically update all connected controllers.");
        GroupLayout bottomPanelLayout = new GroupLayout((Container)this.bottomPanel);
        this.bottomPanel.setLayout((LayoutManager)bottomPanelLayout);
        bottomPanelLayout.setHorizontalGroup((GroupLayout.Group)bottomPanelLayout.createParallelGroup(1).add((GroupLayout.Group)bottomPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)bottomPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)bottomPanelLayout.createSequentialGroup().add((Component)this.saveButton).addPreferredGap(0).add((Component)this.cancelButton).add(169, 169, 169)).add((GroupLayout.Group)bottomPanelLayout.createSequentialGroup().add((Component)this.jLabel2, -1, 380, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)bottomPanelLayout.createSequentialGroup().add((Component)this.jLabel4, -1, 380, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)bottomPanelLayout.createSequentialGroup().add((Component)this.jLabel1, -1, 380, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)bottomPanelLayout.createSequentialGroup().add((Component)this.jLabel3, -1, 380, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)bottomPanelLayout.createSequentialGroup().add((Component)this.jLabel5).addContainerGap(72, Short.MAX_VALUE)))));
        bottomPanelLayout.setVerticalGroup((GroupLayout.Group)bottomPanelLayout.createParallelGroup(1).add((GroupLayout.Group)bottomPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2, -2, 14, -2).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jLabel5).add(13, 13, 13).add((GroupLayout.Group)bottomPanelLayout.createParallelGroup(3).add((Component)this.saveButton).add((Component)this.cancelButton)).addContainerGap()));
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.addEntryButton.setText("Add Entry");
        this.addEntryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PresetsEditor.this.addEntryButtonActionPerformed(evt);
            }
        });
        this.deleteEntryButton.setText("Delete Entry");
        this.deleteEntryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PresetsEditor.this.deleteEntryButtonActionPerformed(evt);
            }
        });
        GroupLayout topPanelLayout = new GroupLayout((Container)this.topPanel);
        this.topPanel.setLayout((LayoutManager)topPanelLayout);
        topPanelLayout.setHorizontalGroup((GroupLayout.Group)topPanelLayout.createParallelGroup(1).add((GroupLayout.Group)topPanelLayout.createSequentialGroup().add(96, 96, 96).add((Component)this.addEntryButton).addPreferredGap(0).add((Component)this.deleteEntryButton).add(120, 120, 120)));
        topPanelLayout.setVerticalGroup((GroupLayout.Group)topPanelLayout.createParallelGroup(1).add((GroupLayout.Group)topPanelLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)topPanelLayout.createParallelGroup(3).add((Component)this.deleteEntryButton).add((Component)this.addEntryButton)).addContainerGap()));
        this.getContentPane().add((Component)this.topPanel, "North");
        this.pack();
    }

    private void deleteEntryButtonActionPerformed(ActionEvent evt) {
        int row = this.presetsTable.getSelectedRow();
        if (row >= 0) {
            int response = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this Location?", "Delete Location", 0);
            if (response == 0) {
                this.presetsTableModel.deleteRow(row);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Select a row to delete.", "Delete Location", 1);
        }
    }

    private void addEntryButtonActionPerformed(ActionEvent evt) {
        this.presetsTableModel.addRow();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.returnValue = 0;
        this.setVisible(false);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.writeFile();
        this.returnValue = 2;
        this.setVisible(false);
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        this.presetsTable.validate();
    }

    public File getFile() {
        return this.file;
    }

    public int getReturnVal() {
        return this.returnValue;
    }

    private void writeFile() {
        this.presetsTableModel.writeData();
    }
}

