/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.gh_everyware_server;

import com.ghe.gh_everyware_server.LatLonLocation;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class PresetsTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"Location name", "Lat (DD.ddd)", "Lon (DDD.ddd)"};
    private Vector vector;
    private Object[][] data;
    private File file;

    public PresetsTableModel(File file) {
        this.file = file;
        this.vector = new Vector();
        try {
            BufferedReader bufferedReader;
            if (file.exists()) {
                bufferedReader = new BufferedReader(new FileReader(file));
            } else {
                file = new File("presets.txt");
                file.createNewFile();
                bufferedReader = new BufferedReader(new FileReader(file));
            }
            boolean eof = false;
            while (!eof) {
                String[] strs;
                String str = bufferedReader.readLine();
                if (str == null) {
                    eof = true;
                    continue;
                }
                if (str.startsWith("#") || (strs = str.split(":")).length != 3) continue;
                String name = strs[0];
                try {
                    double lat = Double.parseDouble(strs[1]);
                    double lon = Double.parseDouble(strs[2]);
                    LatLonLocation loc = new LatLonLocation(name, lat, lon);
                    this.vector.add(loc);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
            }
            this.data = this.vectorToObjectArray(this.vector);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private Object[][] vectorToObjectArray(Vector vector) {
        Object[][] newData = new Object[vector.size()][3];
        for (int i = 0; i < vector.size(); ++i) {
            LatLonLocation loc = (LatLonLocation)vector.get(i);
            newData[i][0] = loc.getName();
            newData[i][1] = new Double(loc.getLat());
            newData[i][2] = new Double(loc.getLon());
        }
        return newData;
    }

    private Vector<LatLonLocation> objArrayToVector(Object[][] obs) {
        Vector<LatLonLocation> vect = new Vector<LatLonLocation>(obs.length);
        for (int i = 0; i < obs.length; ++i) {
            LatLonLocation loc = new LatLonLocation((String)obs[i][0], (Double)obs[i][1], (Double)obs[i][2]);
            vect.add(loc);
        }
        return vect;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }

    public void addRow() {
        this.vector = this.objArrayToVector(this.data);
        this.vector.add(new LatLonLocation("new", 0.0, 0.0));
        this.data = this.vectorToObjectArray(this.vector);
        this.fireTableDataChanged();
    }

    public void deleteRow(int row) {
        this.vector = this.objArrayToVector(this.data);
        this.vector.remove(row);
        this.data = this.vectorToObjectArray(this.vector);
        this.fireTableDataChanged();
    }

    public void writeData() {
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            DataOutputStream out = new DataOutputStream(fos);
            for (int i = 0; i < this.data.length; ++i) {
                for (int j = 0; j < this.data[i].length; ++j) {
                    out.writeBytes(this.data[i][j] + ":");
                }
                out.writeByte(10);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

