/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.gh_everyware_server;

import Serialio.SerialPortLocal;
import com.ghe.event.RotorEvent;
import com.ghe.event.RotorEventListener;
import com.ghe.gh_everyware_server.DeviceFactory;
import com.ghe.gh_everyware_server.DeviceManager;
import com.ghe.gh_everyware_server.IPServer;
import com.ghe.gh_everyware_server.ServerSerialRotor;
import com.ghe.rotor.CablePullListener;
import com.ghe.rotor.DefaultSerialRotor;
import com.ghe.rotor.FixedRotor;
import com.ghe.rotor.SerialRotor;
import com.ghe.wio.Converter;
import com.ghe.wio.IWioStackMatch;
import com.ghe.wio.IWioSwitch;
import com.ghe.wio.IWioSwitchModel;
import com.ghe.wio.StackMatchListener;
import com.ghe.wio.WioRotor;
import com.ghe.wio.WioSwitchListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.SerialPort;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;

public class SerialControlPanel
extends JPanel
implements RotorEventListener,
StackMatchListener,
WioSwitchListener,
CablePullListener {
    private static final int[] STANDARD_BAUD_RATES = new int[]{110, 300, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200, 230400, 460800, 921600};
    private static final String RT4800 = "RT-21";
    public static final String SERIAL_COMMAND = "Serial Command";
    private static final String DCU1 = "DCU-1";
    private static final String VIRTUAL_SWITCH = "Virtual Switch";
    private static final String WIO8 = "GHE Base";
    public static final String ROTOR_FIXED = "Fixed Antenna";
    public static final String ROTOR_CLONE = "Cloned Antenna";
    private static final String SUBTYPE_NA = "N/A";
    public static final String SUBTYPE_ROTOR_RT21 = "RT-21";
    private static final String SUBTYPE_STACKMATCH_LOW = "Stack Match (1-4)";
    private static final String SUBTYPE_STACKMATCH_HIGH = "Stack Match (5-8)";
    private static final String SUBTYPE_FOUR_STACK = "Four Stack (GHE)";
    private static final String SUBTYPE_LBS_STACK = "LBS Stack";
    private static final String SUBTYPE_OK2ZAW_LOW_SIDE = "OK2ZAW (1-4)";
    private static final String SUBTYPE_OK2ZAW_HIGH_SIDE = "OK2ZAW (5-8)";
    public static final double HEADING_NOT_SET = -123456.0;
    public static final double OFFSET_NOT_SET = -654321.0;
    public static final int BAUD_NOT_SET = 0;
    private DeviceManager deviceManager;
    private SerialRotor rotor;
    private IWioStackMatch stackMatch;
    private String portName;
    private String deviceType = "RT-21";
    private String wioAddress = "N/A";
    private String busAddress = "0";
    private String subType = "N/A";
    private double fixedHeading = -123456.0;
    private double oldFixedHeading = 0.0;
    private double cloneOffset = -654321.0;
    private double oldCloneOffset = 0.0;
    private int serialBaudRate = 0;
    private int oldSerialBaudRate = 4800;
    private ComboBoxModel portModel;
    private String[] deviceTypes = new String[]{"RT-21", "Virtual Switch", "GHE Base", "Fixed Antenna", "Cloned Antenna", "Serial Command"};
    private HashMap<String, IWioSwitchModel> customSwitches = new HashMap();
    private boolean initialState;
    private final String[] addressStrings = new String[257];
    private IWioSwitch wioSwitch;
    private RetryThread retryThread;
    private JCheckBox PTTCheckbox;
    private JToggleButton connectButton;
    private JComboBox deviceTypeComboBox;
    private JTextField nameField;
    private JComboBox portComboBox;
    private JComboBox subTypeComboBox;
    private JComboBox wioAddressCombBox;

    public SerialControlPanel(DeviceManager rotorManager, ComboBoxModel model) {
        this.addressStrings[0] = SUBTYPE_NA;
        for (int i = 1; i < 257; ++i) {
            this.addressStrings[i] = Integer.toString(i - 1);
        }
        this.deviceManager = rotorManager;
        this.portModel = model;
        if (this.deviceManager.allowDCU1()) {
            this.deviceTypes = new String[]{"RT-21", DCU1, VIRTUAL_SWITCH, WIO8, ROTOR_FIXED, ROTOR_CLONE, SERIAL_COMMAND};
        }
        this.initComponents();
        this.loadWioSubtypes();
        this.initComPortComboBox();
        this.deviceTypeComboBox.setSelectedItem(this.deviceType);
        this.wioAddressCombBox.setSelectedItem(this.wioAddress);
        this.subTypeComboBox.setSelectedItem(this.subType);
        if (this.deviceType.equals(VIRTUAL_SWITCH) || this.deviceType.equals(WIO8)) {
            this.wioAddressCombBox.setEnabled(true);
            this.subTypeComboBox.setEnabled(true);
            if (this.deviceType.equals(VIRTUAL_SWITCH)) {
                this.wioAddressCombBox.setSelectedItem("0");
                this.wioAddressCombBox.setEnabled(false);
            }
        } else if (this.deviceType.equals(ROTOR_CLONE)) {
            this.wioAddressCombBox.setEnabled(true);
            this.subTypeComboBox.setSelectedItem("RT-21");
            this.subTypeComboBox.setEnabled(false);
        } else {
            this.wioAddressCombBox.setEnabled(false);
            this.subTypeComboBox.setEnabled(false);
            this.wioAddressCombBox.setSelectedItem(SUBTYPE_NA);
            this.subTypeComboBox.setSelectedItem(SUBTYPE_NA);
        }
    }

    public void setPortModel(ComboBoxModel model) {
        this.portModel = model;
    }

    public void connect() {
        this.connectButton.doClick();
    }

    private void initComponents() {
        this.nameField = new JTextField();
        this.portComboBox = new JComboBox(this.portModel);
        this.deviceTypeComboBox = new JComboBox<String>(this.deviceTypes);
        this.connectButton = new JToggleButton();
        this.wioAddressCombBox = new JComboBox();
        this.subTypeComboBox = new JComboBox();
        this.PTTCheckbox = new JCheckBox();
        this.nameField.setPreferredSize(new Dimension(90, 20));
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialControlPanel.this.nameFieldActionPerformed(evt);
            }
        });
        this.portComboBox.setPreferredSize(new Dimension(90, 22));
        this.portComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialControlPanel.this.portComboBoxActionPerformed(evt);
            }
        });
        this.deviceTypeComboBox.setPreferredSize(new Dimension(90, 22));
        this.deviceTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialControlPanel.this.deviceTypeComboBoxActionPerformed(evt);
            }
        });
        this.connectButton.setText("Disconnected");
        this.connectButton.setMaximumSize(new Dimension(120, 23));
        this.connectButton.setMinimumSize(new Dimension(120, 23));
        this.connectButton.setPreferredSize(new Dimension(120, 23));
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialControlPanel.this.connectButtonActionPerformed(evt);
            }
        });
        this.wioAddressCombBox.setModel(new DefaultComboBoxModel<String>(this.addressStrings));
        this.wioAddressCombBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialControlPanel.this.wioAddressCombBoxActionPerformed(evt);
            }
        });
        this.subTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SerialControlPanel.this.subTypeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.nameField, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.portComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.PTTCheckbox).addPreferredGap(0).add((Component)this.deviceTypeComboBox, -2, 143, -2).addPreferredGap(0).add((Component)this.subTypeComboBox, 0, 134, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.wioAddressCombBox, -2, 86, -2).addPreferredGap(1).add((Component)this.connectButton, -2, -1, -2).add(25, 25, 25)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.nameField, -2, -1, -2).add((Component)this.portComboBox, -2, -1, -2).add((Component)this.deviceTypeComboBox, -2, -1, -2).add((Component)this.wioAddressCombBox, -2, -1, -2).add((Component)this.connectButton, -2, -1, -2).add((Component)this.subTypeComboBox, -2, -1, -2).add((Component)this.PTTCheckbox)));
    }

    public void initComPortComboBox() {
        for (int i = 0; i < this.portModel.getSize(); ++i) {
            String str = (String)this.portModel.getElementAt(i);
            if (!str.equals(this.getPortName())) continue;
            this.portModel.setSelectedItem(this.portModel.getElementAt(i));
            break;
        }
    }

    public void setPortOptions(Vector<String> portVector) {
        DefaultComboBoxModel old = (DefaultComboBoxModel)this.portComboBox.getModel();
        String prevSelection = (String)old.getSelectedItem();
        this.portModel = new DefaultComboBoxModel<String>(portVector);
        this.portComboBox.setModel(this.portModel);
        this.setPortName(prevSelection);
    }

    void doConnectAction() throws Exception {
        if (this.nameField.getText().length() < 1) {
            JOptionPane.showMessageDialog(this, "You must supply a name for this device.");
            this.connectButton.setSelected(false);
        } else {
            this.setPortName((String)this.portComboBox.getSelectedItem());
            this.setDeviceType((String)this.deviceTypeComboBox.getSelectedItem());
            this.setWioAddress((String)this.wioAddressCombBox.getSelectedItem());
            this.setSubType((String)this.subTypeComboBox.getSelectedItem());
            if (((String)this.portComboBox.getSelectedItem()).equalsIgnoreCase("NONE") && !ROTOR_FIXED.equals(this.deviceType)) {
                JOptionPane.showMessageDialog(this, "You must supply a port for this device.");
                this.connectButton.setSelected(false);
                return;
            }
            if (ROTOR_FIXED.equals(this.getDeviceType())) {
                this.connectFixed();
            } else if ("RT-21".equals(this.getDeviceType())) {
                this.connectRotor();
            } else if (DCU1.equals(this.getDeviceType())) {
                this.connectDCURotor();
            } else if (VIRTUAL_SWITCH.equals(this.getDeviceType())) {
                this.connectVirtual("wio8");
            } else if (WIO8.equals(this.getDeviceType())) {
                this.connectWIO("wio8");
            } else if (ROTOR_CLONE.equals(this.getDeviceType())) {
                this.connectClone();
            } else if (SERIAL_COMMAND.equals(this.getDeviceType())) {
                this.connectSerialCommand();
            }
            this.initialState = true;
            if (!this.connectButton.getText().equals("Disconnected")) {
                this.disableControls();
            }
        }
    }

    private void doDisconnectAction() {
        boolean close = true;
        try {
            if (this.rotor != null) {
                if (this.rotor instanceof ServerSerialRotor || this.rotor instanceof WioRotor) {
                    close = this.deviceManager.rotorClosing(this);
                }
                if (close) {
                    try {
                        this.rotor.closeConnection();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    this.connectButton.setSelected(true);
                    return;
                }
            }
            if (this.stackMatch != null) {
                this.stackMatch.close();
            }
            if (this.wioSwitch != null) {
                this.wioSwitch.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (close) {
                this.connectButton.setText("Disconnected");
                this.oldFixedHeading = this.getFixedHeading();
                this.setFixedHeading(-123456.0);
                this.oldCloneOffset = this.getCloneOffset();
                this.setCloneOffset(-654321.0);
                this.oldSerialBaudRate = this.getSerialBaudRate();
                this.setSerialBaudRate(0);
                this.enableControls();
                if (this.rotor != null) {
                    this.deviceManager.removeRotor(this.rotor);
                }
                if (this.stackMatch != null) {
                    this.deviceManager.removeStackMatch(this.stackMatch);
                }
                if (this.wioSwitch != null) {
                    this.deviceManager.removeWioSwitch(this.wioSwitch);
                }
                this.initialState = false;
            }
        }
    }

    private void saveDeviceManager() {
        if (!this.deviceManager.isLoading()) {
            this.setPortName((String)this.portComboBox.getSelectedItem());
            this.setDeviceType((String)this.deviceTypeComboBox.getSelectedItem());
            this.setWioAddress((String)this.wioAddressCombBox.getSelectedItem());
            this.setSubType((String)this.subTypeComboBox.getSelectedItem());
            try {
                this.deviceManager.saveSettings();
            }
            catch (IOException e) {
                System.out.println("Failed to save rotor settings...");
                e.printStackTrace();
            }
        }
    }

    private void connectButtonActionPerformed(ActionEvent evt) {
        try {
            this.deviceManager.saveSettings();
        }
        catch (IOException e) {
            System.out.println("Failed to save rotor settings...");
            e.printStackTrace();
        }
        if (this.retryThread != null) {
            this.retryThread.kill();
        }
        if (this.connectButton.isSelected()) {
            try {
                this.doConnectAction();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Exception when opening port..waiting....");
                this.cablePulled();
            }
        } else if (!this.connectButton.isSelected()) {
            this.doDisconnectAction();
        }
        if (this.deviceManager.isInitialized()) {
            try {
                this.deviceManager.saveSettings();
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(SerialControlPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(SerialControlPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void connectFixed() throws IOException {
        try {
            if (this.getFixedHeading() == -123456.0) {
                String str = this.oldFixedHeading == -123456.0 ? JOptionPane.showInputDialog("Enter heading for this fixed antenna:", (Object)0.0) : JOptionPane.showInputDialog("Enter heading for this fixed antenna:", (Object)this.oldFixedHeading);
                if (str == null) {
                    throw new NumberFormatException();
                }
                this.setFixedHeading(Double.parseDouble(str));
            }
            this.rotor = new FixedRotor(this.getFixedHeading());
            this.setName(this.nameField.getText());
            this.rotor.setName(URLDecoder.decode(this.getName(), "UTF-8"));
            this.rotor.addRotorEventListener(this);
            this.rotor.addRotorEventListener(this.deviceManager);
            this.connectButton.setText("Connecting...");
            this.disableControls();
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "You must enter a valid heading.", "Invalid Heading", 0);
        }
    }

    private void connectVirtual(String wioHardwareType) throws Exception {
        this.setName(URLEncoder.encode(this.nameField.getText(), "UTF-8"));
        if (this.customSwitches.containsKey(this.getSubType())) {
            IWioSwitchModel model = this.customSwitches.get(this.getSubType());
            this.wioSwitch = DeviceFactory.getWioSwitch(this.nameField.getText(), this.getPortName(), Integer.parseInt(this.getWioAddress()), model, wioHardwareType, this.getPTT());
            this.wioSwitch.getWioBase().addCablePullListener(this);
            this.wioSwitch.addWioSwitchListener(this);
            this.wioSwitch.addWioSwitchListener(this.deviceManager);
        }
    }

    private void connectClone() throws Exception {
        try {
            if (this.getCloneOffset() == -654321.0) {
                String str = this.oldCloneOffset == -654321.0 ? JOptionPane.showInputDialog("Enter offset for this Cloned antenna (+/- 180.0):", (Object)0.0) : JOptionPane.showInputDialog("Enter offset for this Cloned antenna (+/- 180):", (Object)this.oldCloneOffset);
                if (str == null) {
                    throw new NumberFormatException();
                }
                double d = Double.parseDouble(str);
                if (d < -180.0 || d > 180.0) {
                    throw new NumberFormatException();
                }
                this.setCloneOffset(d);
            }
            this.setName(this.nameField.getText());
            this.rotor = DeviceFactory.getClonedRotor(this.nameField.getText(), this.getPortName(), this.getWioAddress(), this.getBusAddress(), this.getPTT(), this.getCloneOffset());
            this.rotor.addRotorEventListener(this);
            this.rotor.addRotorEventListener(this.deviceManager);
            this.connectButton.setText("Connecting...");
            this.rotor.queryPosition();
            this.disableControls();
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "You must enter a valid OFFSET.", "Invalid OFFSET", 0);
        }
    }

    private void connectRotor() throws Exception {
        this.setName(this.nameField.getText());
        this.rotor = DeviceFactory.getSerialRotor(this.nameField.getText(), this.getPortName());
        this.rotor.addRotorEventListener(this);
        ((DefaultSerialRotor)this.rotor).addCablePullListener(this);
        this.rotor.addRotorEventListener(this.deviceManager);
        this.connectButton.setText("Connecting...");
        this.rotor.queryPosition();
        this.disableControls();
    }

    private void connectDCURotor() throws Exception {
        this.setName(this.nameField.getText());
        this.rotor = DeviceFactory.getDCURotor(this.nameField.getText(), this.getPortName());
        this.rotor.addRotorEventListener(this);
        this.rotor.addRotorEventListener(this.deviceManager);
        this.connectButton.setText("Connecting...");
        this.rotor.queryPosition();
        this.disableControls();
    }

    public static boolean isValidStandardBaudRate(int baudRate) {
        for (int standardRate : STANDARD_BAUD_RATES) {
            if (standardRate != baudRate) continue;
            return true;
        }
        return false;
    }

    private void connectSerialCommand() throws Exception {
        try {
            if (this.getSerialBaudRate() == 0) {
                String str = this.oldSerialBaudRate == 0 ? JOptionPane.showInputDialog("Enter Baud Rate for this Device:", (Object)0) : JOptionPane.showInputDialog("Enter Baud Rate for this Device:", (Object)this.oldSerialBaudRate);
                int rate = Integer.parseInt(str);
                if (!SerialControlPanel.isValidStandardBaudRate(rate)) {
                    throw new NumberFormatException();
                }
                this.setSerialBaudRate(Integer.parseInt(str));
            }
            this.setName(this.nameField.getText());
            this.rotor = DeviceFactory.getSerialCommand(this.nameField.getText(), this.getPortName(), this.getSerialBaudRate());
            this.rotor.addRotorEventListener(this);
            this.rotor.addRotorEventListener(this.deviceManager);
            this.connectButton.setText("Connecting...");
            this.disableControls();
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "You must enter a valid Baud Rate.", "Invalid Baud Rate", 0);
        }
    }

    private void connectWIO(String wioHardwareType) throws IOException, Exception {
        this.connectButton.setText("Validating");
        if (SUBTYPE_NA.equals(this.getSubType())) {
            JOptionPane.showMessageDialog(this, "You must select a WIO subtype.", "Error opening Port", 0);
            this.connectButton.setSelected(false);
            this.connectButton.setText("Disconnected");
            return;
        }
        if (SUBTYPE_STACKMATCH_HIGH.equals(this.getSubType()) || SUBTYPE_STACKMATCH_LOW.equals(this.getSubType())) {
            String str = this.nameField.getText();
            String[] strs = str.split(",");
            String fixedName = "";
            for (int i = 0; i < strs.length; ++i) {
                strs[i] = strs[i].trim();
                fixedName = fixedName + strs[i];
                if (i >= strs.length - 1) continue;
                fixedName = fixedName + ",";
            }
            this.setName(URLEncoder.encode(fixedName, "UTF-8"));
            int stackType = 0;
            if (SUBTYPE_STACKMATCH_HIGH.equals(this.getSubType())) {
                stackType = 4;
            }
            this.stackMatch = DeviceFactory.createWioStackMatch(fixedName, this.getPortName(), Integer.parseInt(this.getWioAddress()), wioHardwareType, stackType, this.getPTT());
            this.stackMatch.getWioBase().addCablePullListener(this);
            this.stackMatch.addStackMatchListener(this);
            this.stackMatch.addStackMatchListener(this.deviceManager);
        } else if (SUBTYPE_OK2ZAW_HIGH_SIDE.equals(this.getSubType()) || SUBTYPE_OK2ZAW_LOW_SIDE.equals(this.getSubType())) {
            String str = this.nameField.getText();
            String[] strs = str.split(",");
            String fixedName = "";
            for (int i = 0; i < strs.length; ++i) {
                strs[i] = strs[i].trim();
                fixedName = fixedName + strs[i];
                if (i >= strs.length - 1) continue;
                fixedName = fixedName + ",";
            }
            this.setName(URLEncoder.encode(fixedName, "UTF-8"));
            int stackType = 32;
            if (SUBTYPE_OK2ZAW_HIGH_SIDE.equals(this.getSubType())) {
                stackType = 64;
            }
            this.stackMatch = DeviceFactory.createWioStackMatch(fixedName, this.getPortName(), Integer.parseInt(this.getWioAddress()), wioHardwareType, stackType, this.getPTT());
            this.stackMatch.getWioBase().addCablePullListener(this);
            this.stackMatch.addStackMatchListener(this);
            this.stackMatch.addStackMatchListener(this.deviceManager);
        } else if (SUBTYPE_FOUR_STACK.equals(this.getSubType())) {
            String str = this.nameField.getText();
            String[] strs = str.split(",");
            String fixedName = "";
            for (int i = 0; i < strs.length; ++i) {
                strs[i] = strs[i].trim();
                fixedName = fixedName + strs[i];
                if (i >= strs.length - 1) continue;
                fixedName = fixedName + ",";
            }
            this.setName(URLEncoder.encode(fixedName, "UTF-8"));
            int stackType = 8;
            this.stackMatch = DeviceFactory.createWioStackMatch(fixedName, this.getPortName(), Integer.parseInt(this.getWioAddress()), wioHardwareType, stackType, this.getPTT());
            this.stackMatch.getWioBase().addCablePullListener(this);
            this.stackMatch.addStackMatchListener(this);
            this.stackMatch.addStackMatchListener(this.deviceManager);
        } else if (SUBTYPE_LBS_STACK.equals(this.getSubType())) {
            String str = this.nameField.getText();
            String[] strs = str.split(",");
            String fixedName = "";
            for (int i = 0; i < strs.length; ++i) {
                strs[i] = strs[i].trim();
                fixedName = fixedName + strs[i];
                if (i >= strs.length - 1) continue;
                fixedName = fixedName + ",";
            }
            this.setName(URLEncoder.encode(fixedName, "UTF-8"));
            int stackType = 16;
            this.stackMatch = DeviceFactory.createWioStackMatch(fixedName, this.getPortName(), Integer.parseInt(this.getWioAddress()), wioHardwareType, stackType, this.getPTT());
            this.stackMatch.getWioBase().addCablePullListener(this);
            this.stackMatch.addStackMatchListener(this);
            this.stackMatch.addStackMatchListener(this.deviceManager);
        } else if ("RT-21".equals(this.getSubType())) {
            this.setName(URLEncoder.encode(this.nameField.getText(), "UTF-8"));
            WioRotor r = (WioRotor)DeviceFactory.createWIORotor(this.nameField.getText(), this.getPortName(), Integer.parseInt(this.getWioAddress()), this.getSubType(), wioHardwareType, this.getPTT());
            r.getWioBase().addCablePullListener(this);
            this.rotor = r;
            this.setName(URLEncoder.encode(this.nameField.getText(), "UTF-8"));
            this.rotor.addRotorEventListener(this);
            this.rotor.addRotorEventListener(this.deviceManager);
            this.rotor.queryPosition();
            this.disableControls();
        } else {
            this.setName(URLEncoder.encode(this.nameField.getText(), "UTF-8"));
            if (this.customSwitches.containsKey(this.getSubType())) {
                IWioSwitchModel model = this.customSwitches.get(this.getSubType());
                this.wioSwitch = DeviceFactory.getWioSwitch(this.nameField.getText(), this.getPortName(), Integer.parseInt(this.getWioAddress()), model, wioHardwareType, this.getPTT());
                this.wioSwitch.getWioBase().addCablePullListener(this);
                this.wioSwitch.addWioSwitchListener(this);
                this.wioSwitch.addWioSwitchListener(this.deviceManager);
            }
        }
        this.connectButton.setText("Connecting...");
        this.disableControls();
    }

    private void deviceTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.deviceTypeComboBox.getSelectedItem().equals(WIO8) || this.deviceTypeComboBox.getSelectedItem().equals(VIRTUAL_SWITCH)) {
            this.PTTCheckbox.setEnabled(true);
        } else {
            this.PTTCheckbox.setEnabled(false);
        }
        if (this.deviceTypeComboBox.getSelectedItem().equals(WIO8)) {
            this.wioAddressCombBox.setEnabled(true);
            this.subTypeComboBox.setEnabled(true);
        } else if (this.deviceTypeComboBox.getSelectedItem().equals(VIRTUAL_SWITCH)) {
            this.wioAddressCombBox.setSelectedItem("0");
            this.wioAddressCombBox.setEnabled(false);
            this.subTypeComboBox.setEnabled(true);
        } else if (this.deviceTypeComboBox.getSelectedItem().equals(ROTOR_CLONE)) {
            this.wioAddressCombBox.setEnabled(true);
            this.subTypeComboBox.setEnabled(true);
        } else {
            this.wioAddressCombBox.setEnabled(false);
            this.subTypeComboBox.setEnabled(false);
            this.wioAddressCombBox.setSelectedItem(SUBTYPE_NA);
            this.subTypeComboBox.setSelectedItem(SUBTYPE_NA);
        }
        this.saveDeviceManager();
    }

    private void subTypeComboBoxActionPerformed(ActionEvent evt) {
        this.saveDeviceManager();
    }

    private void portComboBoxActionPerformed(ActionEvent evt) {
        this.portName = (String)this.portComboBox.getSelectedItem();
        try {
            this.deviceManager.saveSettings();
        }
        catch (IOException e) {
            System.out.println("Couldn't save settings!");
            e.printStackTrace();
        }
    }

    private void PTTCheckboxActionPerformed(ActionEvent evt) {
        this.deviceManager.updatePTTCheckboxes(this.getPortName(), this.getPTT());
        try {
            this.deviceManager.saveSettings();
        }
        catch (IOException e) {
            System.out.println("Couldn't save settings!");
            e.printStackTrace();
        }
    }

    private void wioAddressCombBoxActionPerformed(ActionEvent evt) {
        try {
            this.deviceManager.saveSettings();
        }
        catch (IOException e) {
            System.out.println("Couldn't save settings!");
            e.printStackTrace();
        }
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
        System.out.println("Get fuckeeee");
        try {
            this.deviceManager.saveSettings();
        }
        catch (IOException e) {
            System.out.println("Couldn't save settings!");
            e.printStackTrace();
        }
    }

    private void configurePort() {
        String device = (String)this.deviceTypeComboBox.getSelectedItem();
        if ("RT-21".equals(device)) {
            this.rotor.setBaudRate(4800);
        } else {
            this.rotor.setBaudRate(9600);
        }
    }

    private void disableControls() {
        this.nameField.setEnabled(false);
        this.portComboBox.setEnabled(false);
        this.deviceTypeComboBox.setEnabled(false);
        this.wioAddressCombBox.setEnabled(false);
        this.subTypeComboBox.setEnabled(false);
        this.PTTCheckbox.setEnabled(false);
    }

    private void enableControls() {
        this.nameField.setEnabled(true);
        this.portComboBox.setEnabled(true);
        this.deviceTypeComboBox.setEnabled(true);
        this.PTTCheckbox.setEnabled(true);
        if (this.deviceTypeComboBox.getSelectedItem().equals(WIO8)) {
            this.wioAddressCombBox.setEnabled(true);
            this.subTypeComboBox.setEnabled(true);
        } else if (this.deviceTypeComboBox.getSelectedItem().equals(VIRTUAL_SWITCH)) {
            this.wioAddressCombBox.setSelectedItem("0");
            this.wioAddressCombBox.setEnabled(false);
            this.subTypeComboBox.setEnabled(true);
        } else if (this.deviceTypeComboBox.getSelectedItem().equals(ROTOR_CLONE)) {
            this.wioAddressCombBox.setEnabled(true);
        }
    }

    public void setDisconnected() {
        this.connectButton.setSelected(false);
        this.connectButton.setText("Disconnected");
        this.enableControls();
    }

    public SerialRotor getRotor() {
        return this.rotor;
    }

    public IWioStackMatch getStackMatch() {
        return this.stackMatch;
    }

    public String getNameField() {
        return this.nameField.getText();
    }

    public void saveSettings() throws IOException {
        Properties prop = new Properties();
        File rotordir = new File("rotors");
        if (!rotordir.exists()) {
            rotordir.mkdir();
        }
        String dir = IPServer.getUserDirectory();
        File file = new File(dir + File.separator + "rotor_" + URLEncoder.encode(this.getName(), "UTF-8") + ".ini");
        file.createNewFile();
        prop.load(new FileInputStream(file));
        prop.setProperty("deviceType", "" + this.getDeviceType());
        prop.setProperty("portName", "" + this.getPortName());
        prop.setProperty("wioAddress", "" + this.getWioAddress());
        prop.setProperty("subType", "" + this.getSubType());
        prop.setProperty("busAddress", "" + this.getBusAddress());
        boolean init = false;
        if (this.rotor != null) {
            init = this.getRotor().isPortOpen();
        } else if (this.stackMatch != null) {
            init = this.getStackMatch().isPortOpen();
        } else if (this.wioSwitch != null) {
            init = this.wioSwitch.isPortOpen();
        }
        prop.setProperty("initialState", "" + init);
        if (this.getFixedHeading() == -123456.0) {
            prop.setProperty("fixedHeading", Double.toString(this.oldFixedHeading));
        } else {
            prop.setProperty("fixedHeading", Double.toString(this.getFixedHeading()));
        }
        if (this.getCloneOffset() == -654321.0) {
            prop.setProperty("cloneHeading", Double.toString(this.oldCloneOffset));
        } else {
            prop.setProperty("cloneOffset", Double.toString(this.getCloneOffset()));
        }
        if (this.getSerialBaudRate() == 0) {
            prop.setProperty("serialBaudRate", Integer.toString(this.oldSerialBaudRate));
        } else {
            prop.setProperty("serialBaudRate", Integer.toString(this.getSerialBaudRate()));
        }
        prop.store(new FileOutputStream(file), "");
    }

    private void loadSettings() throws IOException {
        String dir;
        File file;
        Properties prop = new Properties();
        File rotordir = new File("rotors");
        if (!rotordir.exists()) {
            rotordir.mkdir();
        }
        if (!(file = new File((dir = rotordir.getAbsolutePath()) + File.separator + "rotor_" + URLDecoder.decode(this.getName(), "UTF-8") + ".ini")).exists()) {
            file.createNewFile();
        }
        prop.load(new FileInputStream(file));
        this.setDeviceType(prop.getProperty("deviceType", "RT-21"));
        this.setWioAddress(prop.getProperty("wioAddress", SUBTYPE_NA));
        this.setSubType(prop.getProperty("subType", SUBTYPE_NA));
        System.out.println("WSD: " + prop.getProperty("portName", "NONE"));
        this.setPortName(prop.getProperty("portName", "NONE"));
        this.setInitialState(new Boolean(prop.getProperty("initialState", "false")));
        if (this.isInitialState()) {
            this.setFixedHeading(new Double(prop.getProperty("fixedHeading", "0.0")));
            this.setCloneOffset(new Double(prop.getProperty("cloneOffset", "0.0")));
        } else {
            this.oldCloneOffset = new Double(prop.getProperty("cloneOffset", "0.0"));
            if (this.oldCloneOffset == -654321.0) {
                this.oldCloneOffset = 0.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWioSubtypes() {
        Vector<String> v = new Vector<String>();
        v.add(SUBTYPE_NA);
        v.add("RT-21");
        v.add(SUBTYPE_STACKMATCH_LOW);
        v.add(SUBTYPE_STACKMATCH_HIGH);
        v.add(SUBTYPE_FOUR_STACK);
        v.add(SUBTYPE_LBS_STACK);
        v.add(SUBTYPE_OK2ZAW_LOW_SIDE);
        v.add(SUBTYPE_OK2ZAW_HIGH_SIDE);
        try {
            File wioDir = new File(IPServer.getUserDirectory() + "wioProfiles");
            if (!wioDir.exists()) {
                wioDir.mkdir();
            }
            File[] wioFiles = wioDir.listFiles();
            for (int i = 0; i < wioFiles.length; ++i) {
                IWioSwitchModel model = Converter.getWIOSwitchModel(wioFiles[i]);
                if (model == null) continue;
                v.add(model.getName());
                this.customSwitches.put(model.getName(), model);
            }
            File ttDir = new File("./CompositeDevices");
            if (!ttDir.exists()) {
                ttDir.mkdir();
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        finally {
            Object obj = this.subTypeComboBox.getSelectedItem();
            this.subTypeComboBox.setModel(new DefaultComboBoxModel(v));
            this.subTypeComboBox.setSelectedItem(obj);
        }
    }

    @Override
    public synchronized void rotorEventOccurred(RotorEvent evt) {
        this.connectButton.setText("Connected");
        this.rotor.removeRotorEventListener(this);
        this.deviceManager.addRotor(this.rotor);
    }

    @Override
    public synchronized void stackMatchUpdate(IWioStackMatch sm, boolean[] ants, int status, int remoteRSSI) {
        if (status == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SerialControlPanel.this.connectButton.setText("Connected");
                }
            });
            this.deviceManager.addStackMatch(this.stackMatch);
            this.stackMatch.removeStackMatchListener(this);
        }
    }

    @Override
    public void wioSwitchUpdate(IWioSwitch sw, String state, int status, int remoteRSSI) {
        if (status == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SerialControlPanel.this.connectButton.setText("Connected");
                }
            });
            this.deviceManager.addWioSwitch(this.wioSwitch);
            this.wioSwitch.removeWioSwitchListener(this);
        }
    }

    public String getCurrentComPort() {
        String rVal = null;
        if (this.portComboBox.getSelectedItem() != null) {
            rVal = this.portComboBox.getSelectedItem().toString();
        }
        return rVal;
    }

    public String getPortName() {
        if (this.portName != null) {
            return this.portName.replaceAll("\\*", "");
        }
        return null;
    }

    public void setPortName(String portName) {
        this.portName = portName;
        this.portComboBox.setSelectedItem(portName);
        if (!this.portComboBox.getSelectedItem().toString().equals(portName)) {
            Vector<String> ports = new Vector<String>();
            for (int i = 0; i < this.portModel.getSize(); ++i) {
                ports.add(this.portModel.getElementAt(i).toString());
            }
            ports.add(portName);
            this.portModel = new DefaultComboBoxModel(ports);
            this.portComboBox.setModel(this.portModel);
            this.portComboBox.setSelectedItem(portName);
        }
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        this.deviceTypeComboBox.setSelectedItem(deviceType);
    }

    public Boolean getPTT() {
        return this.PTTCheckbox.isSelected();
    }

    public void setPTT(Boolean value) {
        this.PTTCheckbox.setSelected(value);
    }

    public String getWioAddress() {
        return this.wioAddress;
    }

    public String getBusAddress() {
        return this.busAddress;
    }

    public void setWioAddress(String wioAddress) {
        this.wioAddress = wioAddress;
        this.wioAddressCombBox.setSelectedItem(wioAddress);
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
        this.subTypeComboBox.setSelectedItem(subType);
    }

    public double getFixedHeading() {
        return this.fixedHeading;
    }

    public void setFixedHeading(double fixedHeading) {
        this.fixedHeading = fixedHeading;
    }

    public double getCloneOffset() {
        return this.cloneOffset;
    }

    public void setCloneOffset(double cloneOffset) {
        this.cloneOffset = cloneOffset;
    }

    public int getSerialBaudRate() {
        return this.serialBaudRate;
    }

    public void setSerialBaudRate(int baud) {
        this.serialBaudRate = baud;
    }

    public boolean isInitialState() {
        return this.initialState;
    }

    public void setInitialState(boolean initialState) {
        this.initialState = initialState;
    }

    @Override
    public void setName(String name) {
        try {
            super.setName(name);
            this.nameField.setText(URLDecoder.decode(name, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(SerialControlPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void cablePulled() {
        try {
            this.connectButton.setText("Error");
            Thread.sleep(1000L);
            this.retryThread = new RetryThread();
            this.retryThread.start();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(SerialControlPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    class RetryThread
    extends Thread {
        boolean kill = false;

        RetryThread() {
        }

        private Boolean isPortAvailable(String retryPort) {
            String[] ports = null;
            try {
                ports = SerialPortLocal.getPortList();
            }
            catch (IOException ex) {
                Logger.getLogger(DeviceManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int i = 0; i < ports.length; ++i) {
                if (!ports[i].equals(retryPort)) continue;
                try {
                    CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)retryPort);
                }
                catch (NoSuchPortException e) {
                    System.out.println("Add port " + retryPort + " to available ports" + (Object)((Object)e));
                    CommPortIdentifier.addPortName((String)retryPort, (int)1, null);
                }
                return true;
            }
            return false;
        }

        public void kill() {
            this.kill = true;
        }

        @Override
        public void run() {
            SerialControlPanel.this.doDisconnectAction();
            SerialControlPanel.this.initialState = true;
            SerialControlPanel.this.connectButton.setText("Retrying");
            while (!this.kill) {
                try {
                    Thread.sleep(1000L);
                    String p = (String)SerialControlPanel.this.portComboBox.getSelectedItem();
                    boolean success = false;
                    if (this.isPortAvailable(p).booleanValue()) {
                        try {
                            CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)p);
                            if (!portId.isCurrentlyOwned()) {
                                System.out.println("port " + p + " is not owned.  Opening...");
                                SerialPort serialPort = (SerialPort)portId.open(p, 2000);
                                System.out.println("opened " + p);
                                serialPort.close();
                                Thread.sleep(2000L);
                                success = true;
                            }
                        }
                        catch (Exception e) {
                            System.out.println("could not open " + p + " because of " + e);
                            e.printStackTrace();
                            success = false;
                        }
                    }
                    if (!success) continue;
                    System.out.println("recovered missing serial port " + p);
                    Thread.sleep(1000L);
                    SerialControlPanel.this.connectButton.setSelected(false);
                    Thread t2 = new Thread(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(100L);
                                Thread.sleep(5000L);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        SerialControlPanel.this.connect();
                                        SerialControlPanel.this.connectButton.setSelected(true);
                                    }
                                });
                            }
                            catch (Exception ex) {
                                Logger.getLogger(SerialControlPanel.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    };
                    t2.start();
                    this.kill = true;
                }
                catch (Exception ex) {
                    Logger.getLogger(SerialControlPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

