/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.rotor;

import com.ghe.event.RotorCommandEvent;
import com.ghe.event.RotorEvent;
import com.ghe.event.RotorEventListener;
import com.ghe.event.RotorQueryEvent;
import com.ghe.event.RotorStopEvent;
import com.ghe.rotor.SerialRotor;
import java.io.IOException;
import javax.comm.SerialPortEvent;

public class ClonedRotor
extends SerialRotor
implements RotorEventListener {
    private SerialRotor model;
    private boolean open = false;
    private double offset = 0.0;
    public static final int MODEL_UNKNOWN = -1;
    public static final int MODEL_RT20 = 20;
    public static final int MODEL_RT21 = 21;
    public static double TURN_CCW = -1.0E7;
    public static double TURN_CW = -2.0E7;
    protected int modelnumber = -1;

    public ClonedRotor(String name, SerialRotor model, Double myOffset) {
        this.offset = myOffset;
        this.model = model;
        this.setName(name);
        model.addRotorEventListener(this);
        this.open = true;
    }

    @Override
    public boolean isPortOpen() {
        return this.open;
    }

    @Override
    public void closeConnection() throws IOException {
        this.open = false;
    }

    @Override
    public void queryPosition() throws IOException {
        this.model.queryPosition();
    }

    @Override
    public void rotorCommandOccurred(RotorCommandEvent evt) {
        if (evt.getRotor().equals(this.getName())) {
            if (evt.getHeading() == RotorCommandEvent.TURN_CCW) {
                this.model.rotorCommandOccurred(new RotorCommandEvent((Object)this, this.model.getName(), TURN_CCW));
            } else if (evt.getHeading() == RotorCommandEvent.TURN_CW) {
                this.model.rotorCommandOccurred(new RotorCommandEvent((Object)this, this.model.getName(), TURN_CW));
            } else {
                System.out.println("matched this cloned rotor");
                System.out.println("turn this rotator " + this.model.getName() + " " + (evt.getHeading() - this.offset));
                double heading = evt.getHeading() - this.offset;
                if (heading < 0.0) {
                    heading += 360.0;
                }
                if (heading >= 360.0) {
                    heading -= 360.0;
                }
                this.model.rotorCommandOccurred(new RotorCommandEvent((Object)this, this.model.getName(), heading));
            }
        }
    }

    @Override
    public void rotorQueryOccurred(RotorQueryEvent evt) {
        this.model.rotorQueryOccurred(new RotorQueryEvent(evt.getSource(), this.model.getName()));
    }

    @Override
    public void rotorStopEventOccurred(RotorStopEvent evt) {
        if (evt.getRotor().equals(this.getName())) {
            this.model.rotorStopEventOccurred(new RotorStopEvent(evt.getSource(), this.model.getName()));
        }
    }

    public double getOffset() {
        return this.offset;
    }

    public void serialEvent(SerialPortEvent arg0) {
    }

    @Override
    public void rotorEventOccurred(RotorEvent evt) {
        double heading;
        for (heading = evt.getHeading() + this.offset; heading < 0.0; heading += 360.0) {
        }
        while (heading >= 360.0) {
            heading -= 360.0;
        }
        char status = evt.getStatus();
        this.fireRotorEvent(new RotorEvent(this, heading, RotorEvent.STATUS_CLONE, 0));
    }
}

