/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.rotor;

import com.ghe.event.EEUpdateEvent;
import com.ghe.event.RotorCommandEvent;
import com.ghe.event.RotorEvent;
import com.ghe.event.RotorQueryEvent;
import com.ghe.event.RotorStopEvent;
import com.ghe.rotor.CablePullListener;
import com.ghe.rotor.SerialRotor;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.comm.SerialPortEvent;

public class DefaultSerialRotor
extends SerialRotor {
    public static final int SECURITY_USER = 0;
    public static final int SECURITY_ADMIN = 1;
    public static final int SECURITY_OVERRIDE = 2;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_MASTER_SLAVE = 1;
    public static final int MODE_MASTER_CR = 2;
    public static final int MODE_SLAVE_CR = 3;
    public static final int MODE_OFFSET = 4;
    public static final int MODE_DEBUG = 5;
    public static final int ROTORTYPE_POT = 0;
    public static final int ROTORTYPE_COUNTER = 1;
    public static final int ROTORTYPE_HAM = 2;
    public static final int ROTORTYPE_T2X = 3;
    public static final int ROTORTYPE_TIC = 4;
    public static final int ROTORTYPE_ORION = 5;
    public static final int ROTORTYPE_SPID = 6;
    public static final String ACK = "\u0006";
    public static final String SOH = "\u0001";
    public static final int MODEL_UNKNOWN = -1;
    public static final int MODEL_RT20 = 20;
    public static final int MODEL_RT21 = 21;
    protected int modelnumber = -1;
    protected String dataString = "";
    protected boolean poll = false;
    protected int pollInterval = 1000;
    protected Timer t;
    protected volatile int unkCounter = 0;
    private int queryCount = 0;
    protected double currentHeading = 0.0;
    protected final Set<CablePullListener> cablePullListeners = new HashSet<CablePullListener>();

    public DefaultSerialRotor() {
        this.t = new Timer();
    }

    public void setModel(int modelnumber) {
        this.modelnumber = modelnumber;
    }

    public void addCablePullListener(CablePullListener l) {
        this.cablePullListeners.add(l);
    }

    public void removeCablePullListener(CablePullListener l) {
        this.cablePullListeners.remove(l);
    }

    public void setPollRate(int millis) {
        this.pollInterval = millis;
    }

    public void enablePolling(boolean b) {
        if (b) {
            if (this.t != null) {
                this.t.cancel();
            }
            this.t = new Timer();
            this.t.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        DefaultSerialRotor.this.queryPosition();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        DefaultSerialRotor.this.t.cancel();
                    }
                }
            }, 2 * this.pollInterval, (long)this.pollInterval);
        } else {
            this.t.cancel();
        }
    }

    @Override
    public synchronized void rotorCommandOccurred(RotorCommandEvent evt) {
        if (evt.getRotor().equals(this.getName())) {
            if (evt.getHeading() == RotorCommandEvent.TURN_CCW) {
                if (this.modelnumber == 21) {
                    this.turnCCW();
                }
            } else if (evt.getHeading() == RotorCommandEvent.TURN_CW) {
                if (this.modelnumber == 21) {
                    this.turnCW();
                }
            } else if (this.modelnumber == 21) {
                DecimalFormat df = new DecimalFormat("000.0");
                String headingString = df.format(evt.getHeading());
                String commandString = "AP2" + headingString + '\r' + ";";
                try {
                    this.sendToRotor(commandString);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                long heading = Math.round(evt.getHeading());
                String headingString = heading < 10L ? "00" + heading : (heading < 100L ? "0" + heading : "" + heading);
                String commandString = "AP2" + headingString + ";AM2;";
                try {
                    this.sendToRotor(commandString);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public synchronized void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                try {
                    int r;
                    while ((r = this.inputStream.read()) != -1) {
                        char ch = (char)r;
                        this.dataString = this.dataString + ch;
                        if (ch != ';') continue;
                        if (this.dataString.contains(ACK)) {
                            if (this.dataString.charAt(this.dataString.length() - 2) == '\u0006') {
                                this.dataString = "";
                                continue;
                            }
                            if (this.dataString.charAt(this.dataString.length() - 3) != '\u0006') continue;
                            char eeRegister = this.dataString.charAt(this.dataString.length() - 2);
                            this.dataString = "";
                            continue;
                        }
                        if (this.dataString.contains(SOH)) {
                            char eeRegister = this.dataString.charAt(this.dataString.indexOf(SOH) - 1);
                            String value = this.dataString.substring(this.dataString.indexOf(SOH) + 1, this.dataString.length() - 1);
                            this.fireEEUpdateEvent(new EEUpdateEvent(this, eeRegister, value));
                            this.dataString = "";
                            continue;
                        }
                        if (this.dataString.contains(".")) {
                            String[] strs;
                            if (this.dataString.length() <= 1 || (strs = this.dataString.split(";")).length <= 0 || strs[strs.length - 1].length() <= 0) continue;
                            double d = Double.parseDouble(strs[strs.length - 1].substring(0, strs[strs.length - 1].length()));
                            this.fireRotorEvent(new RotorEvent(this, d, '0', 0));
                            this.currentHeading = d;
                            this.queryCount = 0;
                            this.dataString = "";
                            this.modelnumber = 21;
                            continue;
                        }
                        if (this.dataString.length() <= 3) continue;
                        this.dataString = this.dataString.replaceAll(";", " ");
                        this.dataString = this.dataString.substring(this.dataString.length() - 4);
                        this.fireRotorEvent(new RotorEvent(this, Double.parseDouble(this.dataString), '0', 0));
                        this.dataString = "";
                        this.modelnumber = 20;
                    }
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.dataString = "";
                    System.out.println("calling cable pull listeners");
                    for (CablePullListener l : this.cablePullListeners) {
                        l.cablePulled();
                    }
                    System.out.println("removing cable pull listeners");
                    for (CablePullListener l : this.cablePullListeners) {
                        this.removeCablePullListener(l);
                    }
                    System.out.println("cable pull listeners removed");
                    System.out.println("closedall");
                }
            }
        }
    }

    public void stopRotor() throws IOException {
        this.sendToRotor(";");
    }

    @Override
    public void queryPosition() throws IOException {
        try {
            this.sendToRotor("BI2;");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.dataString = "";
            System.out.println("calling cable pull listeners");
            for (CablePullListener l : this.cablePullListeners) {
                l.cablePulled();
            }
            System.out.println("removing cable pull listeners");
            for (CablePullListener l : this.cablePullListeners) {
                this.removeCablePullListener(l);
            }
            System.out.println("cable pull listeners removed");
        }
        ++this.queryCount;
        if (this.queryCount > 5) {
            this.fireRotorEvent(new RotorEvent(this, this.currentHeading, RotorEvent.STATUS_ERROR, 0));
        }
    }

    @Override
    public void rotorQueryOccurred(RotorQueryEvent evt) {
        if (evt.getRotor().equals(this.getName())) {
            try {
                this.queryPosition();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void rotorStopEventOccurred(RotorStopEvent evt) {
        if (evt.getRotor().equals(this.getName())) {
            try {
                this.stopRotor();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void turnCCW() {
        try {
            this.sendToRotor("AA0;");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void turnCW() {
        try {
            this.sendToRotor("AB0;");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setCCWCalValue(int i) {
        try {
            this.sendToRotor("WA0" + i + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setCWCalValue(int i) {
        try {
            this.sendToRotor("WB0" + i + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setSecurity(int i) {
        try {
            this.sendToRotor("WQ0" + i + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setBrightness(int i) {
        try {
            this.sendToRotor("WO2" + i + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setCCWLimit(int i) {
        int limit = i;
        try {
            this.sendToRotor("WH2" + limit + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setCalRange(int degrees) {
        if (degrees == 90 || degrees == 180 || degrees == 270 || degrees == 360) {
            try {
                this.sendToRotor("WL2" + degrees + ";");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setCWLimit(int i) {
        int limit = i;
        try {
            this.sendToRotor("WI2" + limit + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setMaxSpeed(int i) {
        try {
            this.sendToRotor("WG2" + i + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setMinSpeed(int i) {
        try {
            this.sendToRotor("WF2" + i + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setRampDelay(int i) {
        try {
            this.sendToRotor("WN2" + i + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setReverseDelay(int i) {
        try {
            this.sendToRotor("WE2" + i + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setPulseDivider(int i) {
        try {
            this.sendToRotor("WK2" + i + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setRotorType(int i) {
        try {
            this.sendToRotor("WJ2" + i + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setMode(int i) {
        try {
            this.sendToRotor("WM2" + i + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setTimeout(int i) {
        try {
            this.sendToRotor("WP2" + i + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setVanity(String string) {
        try {
            this.sendToRotor("W02" + string + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setOffset(int i) {
        try {
            this.sendToRotor("WD2" + i + ";");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void calibrate(double heading) {
        DecimalFormat df = new DecimalFormat("000.0");
        String headingString = df.format(heading);
        String commandString = "AW1" + headingString + ";";
        try {
            this.sendToRotor(commandString);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void resetEE() {
        try {
            this.sendToRotor("W00;");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void doCCWCalibration() throws IOException {
        this.sendToRotor("C00;");
    }

    public void doCWCalibration() throws IOException {
        this.sendToRotor("C10;");
    }

    public void queryAD_Value() throws IOException {
        this.sendToRotor("R00;");
    }

    public void queryCCWCal() throws IOException {
        this.sendToRotor("RA0;");
    }

    public void queryCWCal() throws IOException {
        this.sendToRotor("RB0;");
    }

    public void queryPulseCount() throws IOException {
        this.sendToRotor("RC0;");
    }

    public void queryCalOffset() throws IOException {
        this.sendToRotor("RD0;");
    }

    public void queryReverseDelay() throws IOException {
        this.sendToRotor("RE0;");
    }

    public void queryMinSpeed() throws IOException {
        this.sendToRotor("RF0;");
    }

    public void queryMaxSpeed() throws IOException {
        this.sendToRotor("RG0;");
    }

    public void queryCCWLimit() throws IOException {
        this.sendToRotor("RH0;");
    }

    public void queryCWLimit() throws IOException {
        this.sendToRotor("RI0;");
    }

    public void queryRotorType() throws IOException {
        this.sendToRotor("RJ0;");
    }

    public void queryPulseDivider() throws IOException {
        this.sendToRotor("RK0;");
    }

    public void queryCalRange() throws IOException {
        this.sendToRotor("RL0;");
    }

    public void queryMode() throws IOException {
        this.sendToRotor("RM0;");
    }

    public void queryRampDelay() throws IOException {
        this.sendToRotor("RN0;");
    }

    public void queryBrightness() throws IOException {
        this.sendToRotor("RO0;");
    }

    public void queryMotorTimeout() throws IOException {
        this.sendToRotor("RP0;");
    }

    public void querySecurity() throws IOException {
        this.sendToRotor("RQ0;");
    }

    public void queryVersion() throws IOException {
        this.sendToRotor("R10;");
    }

    @Override
    public void closeConnection() throws IOException {
        this.t.cancel();
        super.closeConnection();
    }
}

