/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.rotor;

import com.ghe.event.RotorCommandEvent;
import com.ghe.event.RotorEvent;
import com.ghe.event.RotorQueryEvent;
import com.ghe.event.RotorStopEvent;
import com.ghe.rotor.SerialRotor;
import java.io.IOException;
import javax.comm.SerialPortEvent;

public class FixedRotor
extends SerialRotor {
    private final double heading;
    private volatile boolean open;
    private final PollThread pollThread;

    public FixedRotor(double heading) {
        this.heading = heading;
        this.open = true;
        this.pollThread = new PollThread();
        this.pollThread.start();
    }

    @Override
    public void openConnection(String port) {
        this.open = true;
    }

    @Override
    public void closeConnection() {
        this.open = false;
        this.pollThread.kill();
    }

    @Override
    public void queryPosition() throws IOException {
        final FixedRotor rotor = this;
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                    FixedRotor.this.fireRotorEvent(new RotorEvent(rotor, FixedRotor.this.heading, RotorEvent.STATUS_FIXED, 0));
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    @Override
    public boolean isPortOpen() {
        return this.open;
    }

    @Override
    public void rotorCommandOccurred(RotorCommandEvent evt) {
    }

    @Override
    public void rotorQueryOccurred(RotorQueryEvent evt) {
        this.fireRotorEvent(new RotorEvent(this, this.heading, '0', 0));
    }

    @Override
    public void rotorStopEventOccurred(RotorStopEvent evt) {
    }

    public void serialEvent(SerialPortEvent arg0) {
    }

    class PollThread
    extends Thread {
        private volatile boolean kill = false;

        PollThread() {
        }

        public void kill() {
            this.kill = true;
        }

        @Override
        public void run() {
            while (!this.kill) {
                try {
                    FixedRotor.this.queryPosition();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

