/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.wio;

import com.ghe.wio.IWioSwitchModel;
import com.ghe.wio.WioSwitchModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Converter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IWioSwitchModel getWIOSwitchModel(File f) throws MalformedURLException, ParserConfigurationException {
        InputStream in = null;
        WioSwitchModel model = null;
        try {
            if (!f.toString().toLowerCase().endsWith(".xml")) {
                Object var3_3 = null;
                return var3_3;
            }
            URL url = f.toURI().toURL();
            in = url.openStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nameElements = doc.getElementsByTagName("devicename");
            String deviceName = nameElements.item(0).getTextContent();
            String displayType = root.getAttribute("displayType");
            String matrixLockout = root.getAttribute("matrixlockout");
            String virtualSwitch = root.getAttribute("virtualSwitch");
            String hardwareStr = root.getAttribute("hardware");
            model = new WioSwitchModel(deviceName);
            Map<String, int[]> switchingTable = Collections.synchronizedMap(new HashMap());
            if ("SWITCH".equals(displayType)) {
                model.setDisplayType(1);
            } else if ("HEADING".equals(displayType)) {
                model.setDisplayType(2);
            } else if ("BANDSWITCH".equals(displayType)) {
                model.setDisplayType(3);
            } else if ("ON_OFF_BANK".equals(displayType)) {
                model.setDisplayType(4);
            }
            if ("true".equals(matrixLockout)) {
                model.setMatrixLockout(true);
            }
            if ("true".equals(virtualSwitch)) {
                model.setVirtualSwitch(true);
            }
            Vector<String> order = new Vector<String>();
            NodeList positionsList = doc.getElementsByTagName("position");
            for (int i = 0; i < positionsList.getLength(); ++i) {
                Element e;
                String tagname;
                Node node = positionsList.item(i);
                if (!(node instanceof Element) || !"position".equalsIgnoreCase(tagname = (e = (Element)node).getTagName())) continue;
                String orderStr = e.getAttribute("order");
                String beamwidthStr = e.getAttribute("beamwidth");
                String headingStr = e.getAttribute("heading");
                String name = e.getAttribute("name");
                String bidirectionalStr = e.getAttribute("bidirectional");
                String lowerFreqString = e.getAttribute("lowerFreq");
                String upperFreqStr = e.getAttribute("upperFreq");
                model.setHeading(name, Integer.parseInt(headingStr));
                model.setBeamwidth(name, Integer.parseInt(beamwidthStr));
                model.setLowerFrequency(name, Double.parseDouble(lowerFreqString));
                model.setUpperFrequency(name, Double.parseDouble(upperFreqStr));
                model.setBidirectional(name, Boolean.parseBoolean(bidirectionalStr));
                order.add(Integer.parseInt(orderStr), name);
                NodeList realList = e.getElementsByTagName("real");
                for (int j = 0; j < realList.getLength(); ++j) {
                    String[] virtualArray = new String[3];
                    Node realNode = realList.item(j);
                    Element p = (Element)realNode;
                    virtualArray[0] = name;
                    virtualArray[1] = p.getAttribute("name");
                    virtualArray[2] = p.getAttribute("position");
                    model.setVirtualSwitchEntry(virtualArray);
                }
                NodeList pinList = e.getElementsByTagName("pin");
                int[] stateArray = new int[pinList.getLength()];
                for (int j = 0; j < pinList.getLength(); ++j) {
                    Node pinNode = pinList.item(j);
                    Element p = (Element)pinNode;
                    String numberString = p.getAttribute("number");
                    String stateString = p.getAttribute("state");
                    int idx = Integer.parseInt(numberString);
                    if ("on".equals(stateString)) {
                        stateArray[idx] = 1;
                        continue;
                    }
                    if ("off".equals(stateString)) {
                        stateArray[idx] = 0;
                        continue;
                    }
                    if ("dont-care".equals(stateString)) {
                        stateArray[idx] = -1;
                        continue;
                    }
                    if (!"momentary".equals(stateString)) continue;
                    stateArray[idx] = 2;
                }
                switchingTable.put(name, stateArray);
            }
            model.setSwitchingTable(switchingTable);
            model.setOrderedPositionNames(order);
            WioSwitchModel wioSwitchModel = model;
            return wioSwitchModel;
        }
        catch (SAXException ex) {
            Logger.getLogger(Converter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Converter.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                return model;
            }
            catch (IOException ex) {
                Logger.getLogger(Converter.class.getName()).log(Level.SEVERE, null, ex);
                return model;
            }
        }
    }
}

