/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.wio;

import com.ghe.rotor.CablePullListener;
import com.ghe.wio.IWioRotor;
import com.ghe.wio.WioPhysicalRemote;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;

public class WioBase
implements SerialPortEventListener {
    public static final byte REMOTE_COMMAND = -105;
    public static final byte LOCAL_COMMAND = -120;
    public static final byte SERIAL_COMMAND = -127;
    private OutputStream out;
    private InputStream in;
    private ByteArrayOutputStream bis = new ByteArrayOutputStream();
    private volatile int packetLength;
    private WioPhysicalRemote[] physicalRemotes = new WioPhysicalRemote[256];
    private final Object lock = new Object();
    private SerialPort serialPort;
    private volatile boolean validModule = false;
    private boolean commandMode = false;
    private boolean alive;
    private final Set<CablePullListener> cablePullListeners;

    public WioBase(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.cablePullListeners = new HashSet<CablePullListener>();
        this.alive = true;
    }

    public WioBase(SerialPort serialPort) throws IOException, TooManyListenersException {
        this(serialPort.getInputStream(), serialPort.getOutputStream());
        this.alive = true;
        this.serialPort = serialPort;
        serialPort.addEventListener((SerialPortEventListener)this);
        serialPort.notifyOnDataAvailable(true);
        this.validate2();
    }

    public WioPhysicalRemote getPhysicalRemote(int address, String wioHardwareType) {
        if (this.physicalRemotes[address] == null) {
            this.physicalRemotes[address] = new WioPhysicalRemote(this, address, wioHardwareType);
        }
        return this.physicalRemotes[address];
    }

    public IWioRotor getRotor(int wioAddress) {
        IWioRotor rVal = null;
        WioPhysicalRemote remote = this.physicalRemotes[wioAddress];
        if (remote != null) {
            rVal = this.physicalRemotes[wioAddress].getRotor();
        }
        return rVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wioPhysicalRemoteClosed(WioPhysicalRemote remote) {
        System.out.println("+wioPhysicalRemoteClosed");
        this.physicalRemotes[remote.getAddress()] = null;
        boolean close = true;
        for (int i = 0; i < this.physicalRemotes.length; ++i) {
            if (this.physicalRemotes[i] == null) continue;
            close = false;
        }
        if (close) {
            System.out.println("closing base on " + this.serialPort);
            this.alive = false;
            if (this.serialPort != null) {
                try {
                    this.serialPort.removeEventListener();
                }
                catch (Exception exception) {
                }
                finally {
                    this.serialPort.close();
                }
            }
        }
    }

    public boolean isAlive() {
        return this.alive;
    }

    private boolean validate() throws IOException {
        this.commandMode = false;
        this.validModule = false;
        try {
            this.sendData("+++".getBytes());
            Thread.sleep(1200L);
            if (!this.commandMode) {
                String str = "";
                if (this.serialPort != null) {
                    str = this.serialPort.getName();
                    str = str.replace("/", "");
                    str = str.replace(".", "");
                }
                this.serialPort.close();
                throw new IOException("Base module did not respond on " + str + ".");
            }
            this.sendData("ATDD\r".getBytes());
            Thread.sleep(300L);
            if (!this.validModule) {
                String str = "";
                if (this.serialPort != null) {
                    str = this.serialPort.getName();
                    str = str.replace("/", "");
                    str = str.replace(".", "");
                }
                this.in.close();
                this.out.close();
                this.serialPort.close();
                throw new IOException("Invalid base module detected on " + str + ".  Contact Green Heron Engineering.");
            }
            this.commandMode = false;
            this.sendData("ATCN\r".getBytes());
            Thread.sleep(100L);
            this.commandMode = false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.validModule;
    }

    private void validate2() throws IOException {
        try {
            byte[] pdu = this.createValidatePDU((byte)0);
            this.sendData(pdu);
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(WioBase.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private byte[] createValidatePDU(byte state) {
        byte[] b = new byte[]{126, 0, 5, 8, 0, 68, 68, 0, 0};
        byte[] rVal = WioBase.check(b);
        return rVal;
    }

    static byte[] check(byte[] pdu) {
        byte check;
        int sum = 0;
        for (int i = 3; i < pdu.length - 1; ++i) {
            sum += pdu[i];
        }
        pdu[pdu.length - 1] = check = (byte)(255 - sum);
        return pdu;
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                try {
                    while (this.in.available() > 0) {
                        byte c = (byte)this.in.read();
                        byte[] data = new byte[]{};
                        this.bis.write(c);
                        data = this.bis.toByteArray();
                        if (data.length <= 2) continue;
                        if (data[0] == 126 && data[1] == 0) {
                            this.packetLength = data[2];
                            if (data.length < this.packetLength + 4) continue;
                            this.bis.reset();
                            this.bis = new ByteArrayOutputStream();
                            this.packetLength = 0;
                            this.processData(data);
                            continue;
                        }
                        if (this.commandMode) {
                            if (data[data.length - 1] != 13) continue;
                            if (data.length > 4 && data[0] == 49 && data[1] == 49 && data[2] == 48 && data[3] == 55) {
                                this.validModule = true;
                                this.bis = new ByteArrayOutputStream();
                                this.packetLength = 0;
                                continue;
                            }
                            this.bis = new ByteArrayOutputStream();
                            this.packetLength = 0;
                            this.bis = new ByteArrayOutputStream();
                            this.packetLength = 0;
                            continue;
                        }
                        if (data[0] == 79 && data[1] == 75) {
                            this.commandMode = true;
                            System.out.println("Command mode.");
                            this.bis = new ByteArrayOutputStream();
                            this.packetLength = 0;
                            continue;
                        }
                        System.out.println("Bad packet.");
                        System.out.println(this.byteArrayToHex(data));
                        this.bis = new ByteArrayOutputStream();
                        this.packetLength = 0;
                    }
                    break;
                }
                catch (IOException ex) {
                    for (CablePullListener l : this.cablePullListeners) {
                        l.cablePulled();
                    }
                    for (CablePullListener l : this.cablePullListeners) {
                        this.removeCablePullListener(l);
                    }
                    try {
                        ex.printStackTrace();
                        for (int i = 0; i < this.physicalRemotes.length; ++i) {
                            if (this.physicalRemotes[i] == null) continue;
                            this.physicalRemotes[i].close();
                        }
                        System.out.println("Closing port " + this.serialPort.getName());
                        this.serialPort.close();
                        System.out.println("closedall");
                        break;
                    }
                    catch (Throwable ex1) {
                        Logger.getLogger(WioBase.class.getName()).log(Level.SEVERE, null, ex1);
                    }
                }
            }
        }
    }

    public String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processData(byte[] data) {
        Object object = this.lock;
        synchronized (object) {
            int wioAddress = -1;
            if (data[3] == -105) {
                wioAddress = data[14];
            } else if (data[3] == -120) {
                wioAddress = 0;
            } else if (data[3] == -127) {
                wioAddress = data[5];
            }
            if (wioAddress != -1 && this.physicalRemotes[wioAddress] != null) {
                this.physicalRemotes[wioAddress].processData(data);
            }
        }
    }

    public void sendData(byte[] data) throws IOException {
        block7: {
            try {
                if (this.serialPort == null) break block7;
                if (this.serialPort.getFlowControlMode() == 2) {
                    if (this.serialPort.isCTS()) {
                        this.out.write(data);
                    }
                } else {
                    this.out.write(data);
                }
            }
            catch (IOException ex) {
                for (CablePullListener l : this.cablePullListeners) {
                    l.cablePulled();
                }
                for (CablePullListener l : this.cablePullListeners) {
                    this.removeCablePullListener(l);
                }
            }
        }
    }

    static void printArray(byte[] b) {
        String s = "";
        for (int i = 0; i < b.length; ++i) {
            s = s + Integer.toHexString(b[i]) + " ";
        }
    }

    public void addCablePullListener(CablePullListener l) {
        this.cablePullListeners.add(l);
    }

    public void removeCablePullListener(CablePullListener l) {
        this.cablePullListeners.remove(l);
    }
}

