/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.gh_everyware_server;

import com.ghe.gh_everyware_server.IPServer;
import com.ghe.gh_everyware_server.ServerSerialRotor;
import com.ghe.rotor.ClonedRotor;
import com.ghe.rotor.DCURotor;
import com.ghe.rotor.SerialCommandRotor;
import com.ghe.rotor.SerialRotor;
import com.ghe.wio.IWioRotor;
import com.ghe.wio.IWioStackMatch;
import com.ghe.wio.IWioSwitch;
import com.ghe.wio.IWioSwitchModel;
import com.ghe.wio.WioBase;
import com.ghe.wio.WioPhysicalRemote;
import com.ghe.wio.WioRotor;
import com.ghe.wio.WioStackMatch;
import com.ghe.wio.WioSwitch;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

public class DeviceFactory {
    private static final Map<String, SerialRotor> comRotorMap = Collections.synchronizedMap(new HashMap());
    private static final Map<String, WioBase> wioMap = Collections.synchronizedMap(new HashMap());
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SerialRotor getSerialRotor(String name, String portName) throws IOException, TooManyListenersException, UnsupportedCommOperationException, NoSuchPortException, PortInUseException {
        ServerSerialRotor rotor = new ServerSerialRotor();
        Object object = lock;
        synchronized (object) {
            rotor.setName(name);
            rotor.setBaudRate(4800);
            rotor.openConnection(portName);
            comRotorMap.put(portName, rotor);
        }
        return rotor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SerialRotor getDCURotor(String name, String portName) throws IOException, TooManyListenersException, UnsupportedCommOperationException, NoSuchPortException, PortInUseException {
        DCURotor rotor = new DCURotor();
        rotor.enablePolling(true);
        Object object = lock;
        synchronized (object) {
            rotor.setName(name);
            rotor.setBaudRate(4800);
            rotor.openConnection(portName);
            comRotorMap.put(portName, rotor);
        }
        return rotor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SerialRotor getSerialCommand(String name, String portName, int baud) throws IOException, TooManyListenersException, UnsupportedCommOperationException, NoSuchPortException, PortInUseException {
        SerialCommandRotor rotor = new SerialCommandRotor();
        rotor.enablePolling(true);
        Object object = lock;
        synchronized (object) {
            rotor.setName(name);
            rotor.setBaudRate(baud);
            rotor.openConnection(portName);
            comRotorMap.put(portName, rotor);
        }
        return rotor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SerialRotor createWIORotor(String name, String portName, int wioAddress, String subtype, String wioHardwareType, Boolean PTT) throws Exception {
        WioRotor rotor = null;
        Object object = lock;
        synchronized (object) {
            WioBase wioBase = DeviceFactory.getWioBase(portName, PTT);
            WioPhysicalRemote remote = wioBase.getPhysicalRemote(wioAddress, wioHardwareType);
            rotor = new WioRotor(wioAddress, remote, 9374738);
            rotor.setName(name);
        }
        return rotor;
    }

    public static IWioRotor getWIORotor(String _portName, int _wioAddress, String _subType) {
        WioBase wioBase = wioMap.get(_portName);
        IWioRotor rotor = wioBase.getRotor(_wioAddress);
        return rotor;
    }

    public static SerialRotor getClonedRotor(String name, String portName, String wioAddress, String busAddress, Boolean PTT, Double offset) throws Exception {
        SerialRotor rVal = comRotorMap.get(portName);
        if (rVal == null && !"N/A".equals(wioAddress)) {
            IWioRotor rotor;
            int wioAdd = Integer.parseInt(wioAddress);
            WioBase wioBase = DeviceFactory.getWioBase(portName, PTT);
            if (wioBase != null && (rotor = wioBase.getRotor(wioAdd)) instanceof SerialRotor) {
                rVal = (SerialRotor)((Object)rotor);
            }
        }
        if (rVal != null) {
            return new ClonedRotor(name, rVal, offset);
        }
        throw new Exception("Port " + portName + " does not have a rotor connected to it.\n Did you forget to specify an address for a WIO rotor?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IWioStackMatch createWioStackMatch(String name, String portName, int wioAddress, String wioHardwareType, int stackType, Boolean PTT) throws Exception {
        WioStackMatch stackMatch = null;
        Object object = lock;
        synchronized (object) {
            WioBase wioBase = DeviceFactory.getWioBase(portName, PTT);
            WioPhysicalRemote phyRemote = wioBase.getPhysicalRemote(wioAddress, wioHardwareType);
            stackMatch = new WioStackMatch(wioAddress, phyRemote, stackType);
            stackMatch.setName(name);
        }
        return stackMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IWioSwitch getWioSwitch(String name, String portName, int wioAddress, IWioSwitchModel model, String wioHardwareType, Boolean PTT) throws Exception {
        WioSwitch wioSwitch = null;
        Object object = lock;
        synchronized (object) {
            WioBase wioBase = DeviceFactory.getWioBase(portName, PTT);
            WioPhysicalRemote phyRemote = wioBase.getPhysicalRemote(wioAddress, wioHardwareType);
            wioSwitch = new WioSwitch(wioAddress, phyRemote, model, name);
        }
        return wioSwitch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WioBase getWioBase(String portName, Boolean PTT) throws IOException, TooManyListenersException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException {
        WioBase wioBase = null;
        Object object = lock;
        synchronized (object) {
            wioBase = wioMap.get(portName);
            if ("RemoteAntenna".equals(portName) && (wioBase == null || !wioBase.isAlive())) {
                Properties p = new Properties();
                p.load(new FileInputStream(IPServer.getUserDirectory() + "ports.ini"));
                String s = (String)p.get("RemoteAntenna");
                String[] strs = s.split(":");
                Socket sock = new Socket(strs[0], Integer.parseInt(strs[1]));
                wioBase = new WioBase(sock.getInputStream(), sock.getOutputStream());
                wioMap.put(portName, wioBase);
            } else if (wioBase == null || !wioBase.isAlive()) {
                CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)portName);
                SerialPort serialPort = (SerialPort)portId.open(portName, 2000);
                serialPort.setSerialPortParams(9600, 8, 1, 0);
                serialPort.enableReceiveTimeout(3000);
                if (!PTT.booleanValue()) {
                    serialPort.setFlowControlMode(0);
                } else {
                    serialPort.setFlowControlMode(2);
                }
                if (PTT.booleanValue() && !serialPort.isCTS()) {
                    serialPort.close();
                    throw new IOException("The GH Base unit on " + portName + " does not support Base PTT Mode");
                }
                wioBase = new WioBase(serialPort);
                wioMap.put(portName, wioBase);
            }
        }
        return wioBase;
    }
}

