/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.gh_everyware_server;

import Serialio.SerialPortLocal;
import com.ghe.event.RotorEvent;
import com.ghe.event.RotorEventListener;
import com.ghe.gh_everyware_server.IPServer;
import com.ghe.gh_everyware_server.RotorManagerHeadingPanel;
import com.ghe.gh_everyware_server.SerialControlPanel;
import com.ghe.gh_everyware_server.switchEditor.WioSwitchEditor;
import com.ghe.rotor.SerialRotor;
import com.ghe.wio.IWioStackMatch;
import com.ghe.wio.IWioSwitch;
import com.ghe.wio.StackMatchListener;
import com.ghe.wio.WioSwitchListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeviceManager
extends JFrame
implements RotorEventListener,
StackMatchListener,
WioSwitchListener {
    private static final String settingsXMLFilename = "DeviceManager.xml";
    String[] rotorNames;
    private static int NUM_PANELS = 100;
    private IPServer ipServer;
    private SerialControlPanel[] controlPanels;
    private boolean initialized;
    private boolean loading;
    private JPanel centerPanel;
    private JMenuItem closeMenuItem;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JMenuItem profileMenuItem;
    private JMenuItem refreshComMenuItem;
    private JMenuItem rescanMenuItem;

    public DeviceManager(IPServer ipServer) {
        this.ipServer = ipServer;
        Vector<Object> portVector = new Vector();
        portVector = this.getAvailablePortNames(false);
        this.initComponents();
        this.centerPanel.add(new RotorManagerHeadingPanel());
        this.controlPanels = new SerialControlPanel[NUM_PANELS];
        for (int i = 0; i < NUM_PANELS; ++i) {
            this.controlPanels[i] = new SerialControlPanel(this, new DefaultComboBoxModel(portVector));
            this.centerPanel.add(this.controlPanels[i]);
        }
        this.setLocationRelativeTo(ipServer);
        this.pack();
        this.validate();
        this.loadSettings();
        this.initialized = true;
        this.loading = false;
        this.setSize(800, 600);
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void updatePTTCheckboxes(String comport, Boolean value) {
        for (int i = 0; i < this.controlPanels.length; ++i) {
            if (!this.controlPanels[i].getPortName().equals(comport)) continue;
            this.controlPanels[i].setPTT(value);
        }
    }

    public Vector<String> getAvailablePortNames() {
        return this.getAvailablePortNames(false);
    }

    public Vector<String> getAvailablePortNames(boolean useOldPorts) {
        Vector<String> rVal = new Vector<String>();
        rVal.add("N/A");
        String[] ports = null;
        try {
            ports = SerialPortLocal.getPortList();
        }
        catch (IOException ex) {
            Logger.getLogger(DeviceManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (int i = 0; i < ports.length; ++i) {
            rVal.addElement(ports[i]);
        }
        if (useOldPorts) {
            Vector<String> oldPorts = this.getPortsInXML();
            for (String port : oldPorts) {
                if (rVal.contains(port)) continue;
                rVal.add(port);
            }
        }
        Properties p = new Properties();
        try {
            p.load(new InputStreamReader(new FileInputStream(IPServer.getUserDirectory() + "ports.ini")));
            for (Object key : p.keySet()) {
                rVal.add((String)key);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DeviceManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getPortsInXML() {
        Vector<String> rVal = new Vector<String>();
        InputStream in = null;
        File f = new File(IPServer.getUserDirectory() + settingsXMLFilename);
        try {
            if (!f.exists()) {
                f.createNewFile();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));
                writer.write(this.toXML());
                writer.flush();
                writer.close();
            }
            URL url = f.toURI().toURL();
            in = url.openStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nameElements = doc.getElementsByTagName("panel");
            for (int i = 0; i < nameElements.getLength(); ++i) {
                Element e;
                String port;
                Node node = nameElements.item(i);
                if (!(node instanceof Element) || (port = (e = (Element)node).getAttribute("port")) == null || "".equals(port) || rVal.contains(port)) continue;
                rVal.add(port);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return rVal;
        }
    }

    public void rescanPorts() {
        Vector<String> portNames = this.getAvailablePortNames();
        for (String s : portNames) {
            System.out.println("    " + s);
        }
        for (int i = 0; i <= 4 && i < NUM_PANELS; ++i) {
            String oldPort = this.controlPanels[i].getPortName();
            System.out.println("Yolo " + oldPort);
            this.controlPanels[i].setPortOptions(portNames);
            this.controlPanels[i].setPortName(oldPort);
        }
    }

    boolean allowDCU1() {
        return this.ipServer.allowDCU1();
    }

    boolean isInitialized() {
        return this.initialized;
    }

    void refreshComPorts() {
        this.loading = true;
        Vector<String> v = this.getAvailablePortNames();
        for (int i = 0; i < this.controlPanels.length; ++i) {
            this.controlPanels[i].initComPortComboBox();
        }
        this.loading = false;
    }

    boolean rotorClosing(SerialControlPanel panel) {
        return true;
    }

    private void initComponents() {
        this.refreshComMenuItem = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.centerPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.closeMenuItem = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.profileMenuItem = new JMenuItem();
        this.rescanMenuItem = new JMenuItem();
        this.refreshComMenuItem.setText("Refresh COM ports");
        this.refreshComMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeviceManager.this.refreshComMenuItemActionPerformed(evt);
            }
        });
        this.setTitle("Device Manager");
        this.setIconImage(IPServer.IMAGE_ICON.getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                DeviceManager.this.formWindowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                DeviceManager.this.formWindowClosing(evt);
            }
        });
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.jScrollPane1.setViewportView(this.centerPanel);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jMenu1.setText("File");
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeviceManager.this.closeMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.closeMenuItem);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.profileMenuItem.setText("WIO Profile Editor");
        this.profileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeviceManager.this.profileMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.profileMenuItem);
        this.rescanMenuItem.setText("Rescan ports...");
        this.rescanMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeviceManager.this.rescanMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.rescanMenuItem);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void profileMenuItemActionPerformed(ActionEvent evt) {
        WioSwitchEditor ed = new WioSwitchEditor(this);
        ed.setVisible(true);
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void refreshComMenuItemActionPerformed(ActionEvent evt) {
        this.refreshComPorts();
    }

    private void rescanMenuItemActionPerformed(ActionEvent evt) {
        this.rescanPorts();
    }

    private void formWindowClosed(WindowEvent evt) {
        try {
            this.saveSettings();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DeviceManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DeviceManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        try {
            this.saveSettings();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DeviceManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DeviceManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void getHeading(String rotorName) {
        for (int i = 0; i < this.controlPanels.length; ++i) {
            try {
                if (!this.controlPanels[i].getName().equals(rotorName)) continue;
                this.controlPanels[i].getRotor().queryPosition();
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void getAllHeadings() {
        for (int i = 0; i < this.controlPanels.length; ++i) {
            try {
                this.controlPanels[i].getRotor().queryPosition();
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void addRotor(SerialRotor rotor) {
        this.ipServer.addRotor(rotor);
    }

    public void removeRotor(SerialRotor rotor) {
        this.ipServer.removeRotor(rotor);
    }

    public void addStackMatch(IWioStackMatch sm) {
        this.ipServer.addStackMatch(sm);
    }

    public void removeStackMatch(IWioStackMatch sm) {
        this.ipServer.removeStackMatch(sm);
    }

    public void addWioSwitch(IWioSwitch sw) {
        this.ipServer.addWioSwitch(sw);
    }

    public void removeWioSwitch(IWioSwitch sw) {
        this.ipServer.removeWioSwitch(sw);
    }

    @Override
    public void rotorEventOccurred(RotorEvent evt) {
        Object source = evt.getSource();
        if (source instanceof SerialRotor) {
            SerialRotor serialRotor = (SerialRotor)source;
        }
    }

    @Override
    public void stackMatchUpdate(IWioStackMatch stackMatch, boolean[] ants, int status, int remoteRSSI) {
    }

    @Override
    public void wioSwitchUpdate(IWioSwitch wioSwitch, String state, int status, int remoteRSSI) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() {
        InputStream in = null;
        Vector<String> legacyPorts = this.getAvailablePortNames(true);
        File f = new File(IPServer.getUserDirectory() + settingsXMLFilename);
        try {
            if (!f.exists()) {
                f.createNewFile();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));
                writer.write(this.toXML());
                writer.flush();
                writer.close();
            }
            URL url = f.toURI().toURL();
            in = url.openStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nameElements = doc.getElementsByTagName("panel");
            for (int i = 0; i < nameElements.getLength(); ++i) {
                Node node = nameElements.item(i);
                if (!(node instanceof Element)) continue;
                Element e = (Element)node;
                String deviceType = e.getAttribute("deviceType");
                String name = e.getAttribute("name");
                String orderStr = e.getAttribute("order");
                String port = e.getAttribute("port");
                String subType = e.getAttribute("subType");
                String wioAddress = e.getAttribute("wioAddress");
                String busAddress = e.getAttribute("busAddress");
                String fixedHeadingStr = e.getAttribute("fixedHeading");
                String cloneOffsetStr = e.getAttribute("cloneOffset");
                String initialState = e.getAttribute("initialState");
                String serialBaudStr = e.getAttribute("serialBaudRate");
                Boolean basePTT = e.getAttribute("basePTT").equals("true");
                int order = i;
                if (!"".equals(orderStr)) {
                    order = Integer.parseInt(orderStr);
                }
                Integer.parseInt(orderStr);
                this.controlPanels[order].setName(name);
                if (deviceType.equals("WIO 8")) {
                    this.controlPanels[order].setDeviceType("GHE Base");
                } else if (deviceType.equals("WIO 6")) {
                    this.controlPanels[order].setDeviceType("GHE Base");
                } else {
                    this.controlPanels[order].setDeviceType(deviceType);
                }
                this.controlPanels[order].setPortName(port);
                this.controlPanels[order].setSubType(subType);
                this.controlPanels[order].setWioAddress(wioAddress);
                this.controlPanels[order].setName(name);
                this.controlPanels[order].setPTT(basePTT);
                if (!"".equals(fixedHeadingStr)) {
                    this.controlPanels[order].setFixedHeading(Double.parseDouble(fixedHeadingStr));
                }
                if (!"".equals(cloneOffsetStr)) {
                    this.controlPanels[order].setCloneOffset(Double.parseDouble(cloneOffsetStr));
                }
                if (!"".equals(serialBaudStr)) {
                    this.controlPanels[order].setSerialBaudRate(Integer.parseInt(serialBaudStr));
                }
                if (!"true".equals(initialState)) continue;
                this.controlPanels[i].connect();
            }
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(DeviceManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(DeviceManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DeviceManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ex) {
                Logger.getLogger(DeviceManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void setVisible(boolean b) {
        this.setLocationRelativeTo(this.ipServer);
        super.setVisible(b);
    }

    public void saveSettings() throws FileNotFoundException, IOException {
        int i;
        if (!this.initialized) {
            return;
        }
        Properties prop = new Properties();
        File file = new File(IPServer.getUserDirectory() + "rotornames.ini");
        if (!file.exists()) {
            file.createNewFile();
        }
        prop.load(new FileInputStream(file));
        String names = "";
        try {
            for (i = 0; i < this.controlPanels.length; ++i) {
                names = names + this.controlPanels[i].getNameField() + ":";
            }
        }
        catch (NullPointerException np) {
            return;
        }
        prop.put("rotorNames", names);
        for (i = 0; i < this.controlPanels.length; ++i) {
        }
        prop.store(new FileOutputStream(file), "");
        File xmlFile = new File(IPServer.getUserDirectory() + settingsXMLFilename);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(xmlFile)));
        writer.write(this.toXML());
        writer.flush();
        writer.close();
    }

    public void updateWioTypes() {
        for (int i = 0; i < this.controlPanels.length; ++i) {
            this.controlPanels[i].loadWioSubtypes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toXML() {
        String xmlString = "error writing xml";
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            String root = "DeviceManager";
            Element rootElement = document.createElement(root);
            Object displayType = null;
            document.appendChild(rootElement);
            for (int i = 0; i < this.controlPanels.length; ++i) {
                String panelname = this.controlPanels[i].getNameField();
                String order = "" + i;
                String port = this.controlPanels[i].getCurrentComPort();
                String deviceType = this.controlPanels[i].getDeviceType();
                String wioAddress = this.controlPanels[i].getWioAddress();
                String subType = this.controlPanels[i].getSubType();
                String fixedHeading = "" + this.controlPanels[i].getFixedHeading();
                String cloneOffset = "" + this.controlPanels[i].getCloneOffset();
                String serialBaudRate = "" + this.controlPanels[i].getSerialBaudRate();
                String basePTT = this.controlPanels[i].getPTT() != false ? "true" : "false";
                Element panelElement = document.createElement("panel");
                panelElement.setAttribute("name", panelname);
                panelElement.setAttribute("order", order);
                panelElement.setAttribute("port", port);
                panelElement.setAttribute("deviceType", deviceType);
                panelElement.setAttribute("wioAddress", wioAddress);
                panelElement.setAttribute("subType", subType);
                panelElement.setAttribute("basePTT", basePTT);
                if ("Fixed Antenna".equals(deviceType)) {
                    panelElement.setAttribute("fixedHeading", fixedHeading);
                }
                if ("Cloned Antenna".equals(deviceType)) {
                    panelElement.setAttribute("cloneOffset", cloneOffset);
                }
                if ("Serial Command".equals(deviceType)) {
                    panelElement.setAttribute("serialBaudRate", serialBaudRate);
                }
                panelElement.setAttribute("initialState", "" + this.controlPanels[i].isInitialState());
                rootElement.appendChild(panelElement);
            }
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(DeviceManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                try {
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource source = new DOMSource(document);
                    StreamResult result = new StreamResult(new StringWriter());
                    transformer.setOutputProperty("indent", "yes");
                    transformer.transform(source, result);
                    return result.getWriter().toString();
                }
                catch (TransformerException ex) {
                    Logger.getLogger(DeviceManager.class.getName()).log(Level.SEVERE, null, ex);
                    return xmlString;
                }
            }
            catch (Throwable throwable) {
                return xmlString;
            }
        }
    }
}

