/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.gh_everyware_server;

import com.ghe.event.RotorCommandEvent;
import com.ghe.event.RotorCommandListener;
import com.ghe.event.RotorEvent;
import com.ghe.event.RotorEventListener;
import com.ghe.event.RotorQueryEvent;
import com.ghe.event.RotorQueryListener;
import com.ghe.event.RotorStopEvent;
import com.ghe.event.RotorStopListener;
import com.ghe.gh_everyware.KeyboardHookProc;
import com.ghe.gh_everyware.KeyboardUDPMonitor;
import com.ghe.gh_everyware.RotorUI;
import com.ghe.gh_everyware_server.DeviceManager;
import com.ghe.gh_everyware_server.LicenseInfo;
import com.ghe.gh_everyware_server.MasterPasswordDialog;
import com.ghe.gh_everyware_server.PasswordDialog;
import com.ghe.gh_everyware_server.PasswordManagerDialog;
import com.ghe.gh_everyware_server.SimpleTcpUdpClient;
import com.ghe.gh_everyware_server.SwingWorker;
import com.ghe.gh_everyware_server.TrigUtils;
import com.ghe.rotor.SerialRotor;
import com.ghe.wio.IWioStackMatch;
import com.ghe.wio.IWioSwitch;
import com.ghe.wio.StackMatchListener;
import com.ghe.wio.WioSwitchListener;
import com.ghe.wio.WioSwitchModel;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class IPServer
extends JFrame
implements RotorEventListener,
StackMatchListener,
WioSwitchListener {
    public static final String US = "\u001f";
    public static final String GS = "\u001d";
    private double lat = 45.5;
    private double lon = 45.5;
    private int port;
    private ServerSocket serverSocket;
    private static Vector<ClientServiceThread> connections;
    private int maxConnections;
    private int currentConnections;
    private DeviceManager rotorManager;
    private PasswordManagerDialog pmd;
    private String locationsString = "";
    private Set<SerialRotor> rotors;
    private Map<String, IWioStackMatch> stackMatches;
    private Map<String, IWioSwitch> wioSwitches;
    private Set<String> mLockedWioSwitches;
    private ArrayList<String[]> virtualWioSwitches;
    private static Map presetsMap;
    protected EventListenerList listenerList;
    private Timer memTimer;
    public static Icon ICON;
    public static ImageIcon IMAGE_ICON;
    private static ImageIcon RUNNING_ICON;
    private static ImageIcon STOPPED_ICON;
    public MessageDigest md;
    private boolean authenticateOnStartup;
    private boolean serverLoggingOnStartup;
    private boolean rotorUiVisible;
    private static byte[] masterPass;
    private Map<String, InetAddress> lockedRotorsMap;
    private SystemTray tray;
    private TrayIcon trayIcon = null;
    private static int frameWidth;
    private static int frameHeight;
    private static int frameX;
    private static int frameY;
    private static boolean serverMinimizedOnStartup;
    private boolean allowDCU1 = false;
    private LicenseInfo licenseInfo = new LicenseInfo();
    private RotorUI rotorUI;
    public static IPServer ipRef;
    private static boolean IPServerDelayFlag;
    private JMenuItem aboutMenuItem;
    private JCheckBoxMenuItem authenticateCheckBox;
    private JLabel connectionsLabel;
    private JPanel connectionsPanel;
    private MenuItem exitMI;
    private JMenuItem exitMenuItem;
    private JFileChooser fc;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JMenuItem localControllerMenuItem;
    private JMenuItem masterPassMenuItem;
    private JMenuItem maxConnectionsMenuItem;
    private JLabel memLabel;
    private JTextArea networkTextArea;
    private PopupMenu popup;
    private JLabel portLabel;
    private JMenuItem portMenuItem;
    private JMenuItem rotorConfigMenuItem;
    private JCheckBoxMenuItem serverLogFileCheckBox;
    private JCheckBoxMenuItem serverMinimizedCheckBox;
    private JLabel serverStatusLabel;
    private JMenu settingsMenu;
    private MenuItem showMI;
    private MenuItem startMI;
    private JMenuItem startServerMenuItem;
    private JPanel statusPanel;
    private MenuItem stopMI;
    private JMenuItem stopServerMenuItem;
    private JMenuItem userMenuItem;
    private JMenu usersMenu;

    /*
     * Unable to fully structure code
     */
    public IPServer() {
        super();
        this.displayText("User Files at " + IPServer.getUserDirectory());
        this.loadLicense(new File(".//license.dat"));
        this.loadMasterPass(new File("masterpass"));
        this.lockedRotorsMap = new HashMap<String, InetAddress>();
        try {
            IPServer.IMAGE_ICON = new ImageIcon(this.getClass().getResource("ghe_icon.jpg"));
            IPServer.RUNNING_ICON = new ImageIcon(this.getClass().getResource("running_icon.jpg"));
            IPServer.STOPPED_ICON = new ImageIcon(this.getClass().getResource("stopped_icon.jpg"));
            this.loadSettings();
            IPServer.connections = new Vector<E>();
            this.rotors = new HashSet<SerialRotor>();
        }
        catch (IOException ex) {
            try {
                ex.printStackTrace();
                IPServer.connections = new Vector<E>();
                this.rotors = new HashSet<SerialRotor>();
            }
            catch (Throwable var2_2) {
                IPServer.connections = new Vector<E>();
                this.rotors = new HashSet<SerialRotor>();
                this.stackMatches = Collections.synchronizedMap(new HashMap<K, V>());
                this.wioSwitches = Collections.synchronizedMap(new HashMap<K, V>());
                this.mLockedWioSwitches = new HashSet<String>();
                this.virtualWioSwitches = new ArrayList<E>();
                this.listenerList = new EventListenerList();
                this.pmd = new PasswordManagerDialog(this);
                this.initComponents();
                this.initSystemTray();
                this.rotorManager = new DeviceManager(this);
                this.authenticateCheckBox.setSelected(this.authenticateOnStartup);
                this.serverLogFileCheckBox.setSelected(this.serverLoggingOnStartup);
                this.setIconImage(IPServer.IMAGE_ICON.getImage());
                this.startServerMenuItem.doClick();
                this.memTimer = new Timer(5000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        IPServer.this.updateMemory();
                    }
                });
                this.memTimer.start();
                if (this.rotorUiVisible) {
                    this.rotorUI = RotorUI.getInstance((int)this.port);
                    this.rotorUI.setVisible(true);
                }
                throw var2_2;
            }
            this.stackMatches = Collections.synchronizedMap(new HashMap<K, V>());
            this.wioSwitches = Collections.synchronizedMap(new HashMap<K, V>());
            this.mLockedWioSwitches = new HashSet<String>();
            this.virtualWioSwitches = new ArrayList<E>();
            this.listenerList = new EventListenerList();
            this.pmd = new PasswordManagerDialog(this);
            this.initComponents();
            this.initSystemTray();
            this.rotorManager = new DeviceManager(this);
            this.authenticateCheckBox.setSelected(this.authenticateOnStartup);
            this.serverLogFileCheckBox.setSelected(this.serverLoggingOnStartup);
            this.setIconImage(IPServer.IMAGE_ICON.getImage());
            this.startServerMenuItem.doClick();
            this.memTimer = new Timer(5000, new /* invalid duplicate definition of identical inner class */);
            this.memTimer.start();
            if (this.rotorUiVisible) {
                this.rotorUI = RotorUI.getInstance((int)this.port);
                this.rotorUI.setVisible(true);
            } else {
                ** GOTO lbl84
            }
        }
        this.stackMatches = Collections.synchronizedMap(new HashMap<K, V>());
        this.wioSwitches = Collections.synchronizedMap(new HashMap<K, V>());
        this.mLockedWioSwitches = new HashSet<String>();
        this.virtualWioSwitches = new ArrayList<E>();
        this.listenerList = new EventListenerList();
        this.pmd = new PasswordManagerDialog(this);
        this.initComponents();
        this.initSystemTray();
        this.rotorManager = new DeviceManager(this);
        this.authenticateCheckBox.setSelected(this.authenticateOnStartup);
        this.serverLogFileCheckBox.setSelected(this.serverLoggingOnStartup);
        this.setIconImage(IPServer.IMAGE_ICON.getImage());
        this.startServerMenuItem.doClick();
        this.memTimer = new Timer(5000, new /* invalid duplicate definition of identical inner class */);
        this.memTimer.start();
        if (this.rotorUiVisible) {
            this.rotorUI = RotorUI.getInstance((int)this.port);
            this.rotorUI.setVisible(true);
        }
        IPServer.IPServerDelayFlag = true;
    }

    boolean allowDCU1() {
        return this.licenseInfo.isAllowDCU1();
    }

    private void initComponents() {
        this.fc = new JFileChooser();
        this.popup = new PopupMenu();
        this.showMI = new MenuItem();
        this.startMI = new MenuItem();
        this.stopMI = new MenuItem();
        this.exitMI = new MenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.networkTextArea = new JTextArea();
        this.statusPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.portLabel = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.connectionsLabel = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel2 = new JLabel();
        this.memLabel = new JLabel();
        this.connectionsPanel = new JPanel();
        this.serverStatusLabel = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.serverLogFileCheckBox = new JCheckBoxMenuItem();
        this.serverMinimizedCheckBox = new JCheckBoxMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.settingsMenu = new JMenu();
        this.startServerMenuItem = new JMenuItem();
        this.stopServerMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.rotorConfigMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.maxConnectionsMenuItem = new JMenuItem();
        this.portMenuItem = new JMenuItem();
        this.usersMenu = new JMenu();
        this.userMenuItem = new JMenuItem();
        this.masterPassMenuItem = new JMenuItem();
        this.authenticateCheckBox = new JCheckBoxMenuItem();
        this.jSeparator3 = new JSeparator();
        this.localControllerMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.popup.setLabel("PopupMenu");
        this.showMI.setFont(new Font("SansSerif", 0, 12));
        this.showMI.setLabel("Show window...");
        this.popup.add(this.showMI);
        this.startMI.setFont(new Font("SansSerif", 0, 12));
        this.startMI.setLabel("Start server...");
        this.popup.add(this.startMI);
        this.stopMI.setFont(new Font("SansSerif", 0, 12));
        this.stopMI.setLabel("Stop server...");
        this.popup.add(this.stopMI);
        this.popup.addSeparator();
        this.exitMI.setFont(new Font("SansSerif", 0, 12));
        this.exitMI.setLabel("Exit");
        this.popup.add(this.exitMI);
        this.setDefaultCloseOperation(0);
        this.setTitle("GH Everyware Server");
        this.setLocation(new Point(0, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                IPServer.this.formWindowClosing(evt);
            }

            @Override
            public void windowIconified(WindowEvent evt) {
                IPServer.this.formWindowIconified(evt);
            }
        });
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(""));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.networkTextArea.setEditable(false);
        this.networkTextArea.setBackground(new Color(0, 0, 0));
        this.networkTextArea.setFont(new Font("Arial", 0, 10));
        this.networkTextArea.setForeground(new Color(255, 255, 102));
        this.networkTextArea.setRows(10);
        this.networkTextArea.setCaretColor(new Color(255, 255, 51));
        this.jScrollPane1.setViewportView(this.networkTextArea);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Port:");
        this.statusPanel.add(this.jLabel1);
        this.portLabel.setHorizontalAlignment(2);
        this.portLabel.setText("--");
        this.portLabel.setText("" + this.port);
        this.statusPanel.add(this.portLabel);
        this.jLabel4.setText("       ");
        this.statusPanel.add(this.jLabel4);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Connections:");
        this.statusPanel.add(this.jLabel3);
        this.connectionsLabel.setText("--");
        this.connectionsLabel.setToolTipText("current/max");
        this.connectionsLabel.setText("0/" + this.maxConnections);
        this.statusPanel.add(this.connectionsLabel);
        this.jLabel5.setText("        ");
        this.statusPanel.add(this.jLabel5);
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Memory:");
        this.statusPanel.add(this.jLabel2);
        this.memLabel.setText("--");
        this.statusPanel.add(this.memLabel);
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.connectionsPanel.setLayout(new BorderLayout());
        this.serverStatusLabel.setIcon(STOPPED_ICON);
        this.connectionsPanel.add((Component)this.serverStatusLabel, "Center");
        this.getContentPane().add((Component)this.connectionsPanel, "North");
        this.fileMenu.setText("File");
        this.serverLogFileCheckBox.setSelected(true);
        this.serverLogFileCheckBox.setText("Server Logging");
        this.fileMenu.add(this.serverLogFileCheckBox);
        this.serverMinimizedCheckBox.setText("Minimize at Startup");
        this.fileMenu.add(this.serverMinimizedCheckBox);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IPServer.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.settingsMenu.setText("Settings");
        this.startServerMenuItem.setText("Start Server...");
        this.startServerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IPServer.this.startServerMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.startServerMenuItem);
        this.stopServerMenuItem.setText("Stop server...");
        this.stopServerMenuItem.setEnabled(false);
        this.stopServerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IPServer.this.stopServerMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.stopServerMenuItem);
        this.settingsMenu.add(this.jSeparator2);
        this.rotorConfigMenuItem.setText("Device Manager...");
        this.rotorConfigMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IPServer.this.rotorConfigMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.rotorConfigMenuItem);
        this.settingsMenu.add(this.jSeparator1);
        this.maxConnectionsMenuItem.setText("Max connections");
        this.maxConnectionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IPServer.this.maxConnectionsMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.maxConnectionsMenuItem);
        this.portMenuItem.setText("Set port...");
        this.portMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IPServer.this.portMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.portMenuItem);
        this.usersMenu.setText("Users/Passwords");
        this.userMenuItem.setText("Users...");
        this.userMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IPServer.this.userMenuItemActionPerformed(evt);
            }
        });
        this.usersMenu.add(this.userMenuItem);
        this.masterPassMenuItem.setText("Change Master Password");
        this.masterPassMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IPServer.this.masterPassMenuItemActionPerformed(evt);
            }
        });
        this.usersMenu.add(this.masterPassMenuItem);
        this.authenticateCheckBox.setText("Authenticate Users");
        this.usersMenu.add(this.authenticateCheckBox);
        this.settingsMenu.add(this.usersMenu);
        this.settingsMenu.add(this.jSeparator3);
        this.localControllerMenuItem.setText("Launch Local Controller...");
        this.localControllerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IPServer.this.localControllerMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.localControllerMenuItem);
        this.jMenuBar1.add(this.settingsMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IPServer.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void formWindowIconified(WindowEvent evt) {
        this.setVisible(false);
    }

    static void secondaryMain(String[] args) {
        Object[] options = new Object[]{"OK", "CANCEL"};
        JOptionPane.showOptionDialog(null, "GH Everyware Server is already running", "ERROR", -1, 2, null, options, options[0]);
    }

    public void initSystemTray() {
        if (SystemTray.isSupported()) {
            this.tray = SystemTray.getSystemTray();
            MouseMotionListener mListener = new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    IPServer.this.trayIcon.displayMessage("GH Server", "Connections: " + connections.size() + "\n", TrayIcon.MessageType.INFO);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            };
            MouseListener mmListener = new MouseListener(){

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        StringBuilder sb = new StringBuilder("");
                        Vector vector = connections;
                        synchronized (vector) {
                            for (int i = 0; i < connections.size(); ++i) {
                                sb.append(((ClientServiceThread)connections.get(i)).getClientID() + "\n");
                            }
                        }
                        String str = new String(sb);
                        IPServer.this.trayIcon.displayMessage(IPServer.this.serverStatusLabel.getToolTipText(), connections.size() + " connections: \n" + str, TrayIcon.MessageType.INFO);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            };
            ActionListener actionListener = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void actionPerformed(ActionEvent evt) {
                    Object obj = evt.getSource();
                    if (obj == IPServer.this.exitMI) {
                        int option = JOptionPane.showConfirmDialog(null, "Are you sure you wish to close the the Server?", "Close Program", 0);
                        if (option != 0) return;
                        try {
                            IPServer.this.closeAllConnections();
                            IPServer.this.serverSocket.close();
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return;
                        }
                        finally {
                            try {
                                IPServer.this.saveSettings();
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                            finally {
                                if (IPServer.this.rotorUI != null) {
                                    KeyboardUDPMonitor.getInstance().stopMonitoring();
                                }
                                System.exit(0);
                            }
                        }
                    }
                    if (obj == IPServer.this.showMI) {
                        IPServer.this.setExtendedState(0);
                        IPServer.this.setVisible(true);
                        return;
                    }
                    if (obj == IPServer.this.startMI) {
                        IPServer.this.startServerMenuItem.doClick();
                        return;
                    }
                    if (obj != IPServer.this.stopMI) return;
                    IPServer.this.stopServerMenuItem.doClick();
                }
            };
            this.exitMI.addActionListener(actionListener);
            this.startMI.addActionListener(actionListener);
            this.showMI.addActionListener(actionListener);
            this.stopMI.addActionListener(actionListener);
            Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("ghe_icon.jpg"));
            this.trayIcon = new TrayIcon(image, "GH Everyware Server", this.popup);
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addActionListener(actionListener);
            this.trayIcon.addMouseListener(mmListener);
            try {
                this.tray.add(this.trayIcon);
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "<HTML><H1>GH Everyware Server</H1><BR><H3>Version 2.7.b10     <BR><BR></H3><H3>http://www.greenheronengineering.com</H3></HTML>", "About", 1, IMAGE_ICON);
    }

    private void rotorConfigMenuItemActionPerformed(ActionEvent evt) {
        this.rotorManager.refreshComPorts();
        this.rotorManager.setVisible(true);
    }

    private void masterPassMenuItemActionPerformed(ActionEvent evt) {
        int option = JOptionPane.showConfirmDialog(this, "Changing the master password will generate a new master password and will close\nthe server program.  This operation cannot be undone.\n\nDo you wish to proceed?", "Warning", 0);
        if (option == 0) {
            PasswordDialog pd = new PasswordDialog(this);
            pd.setVisible(true);
            if (pd.getResponse() == 389473) {
                if (Arrays.equals(masterPass, pd.getPassword())) {
                    MasterPasswordDialog mpd = new MasterPasswordDialog((Frame)this, true);
                    mpd.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(this, "Incorrect Password", "Error", 0);
                }
            }
        }
    }

    private void userMenuItemActionPerformed(ActionEvent evt) {
        PasswordDialog pd = new PasswordDialog(this);
        pd.setVisible(true);
        if (pd.getResponse() == 389473) {
            if (Arrays.equals(masterPass, pd.getPassword())) {
                this.pmd.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this, "Incorrect Password", "Error", 0);
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exitMenuItem.doClick();
        KeyboardHookProc.kill();
    }

    private void maxConnectionsMenuItemActionPerformed(ActionEvent evt) {
        String str = JOptionPane.showInputDialog(this, "Enter max number of simultaneous connections:", this.maxConnections);
        if (str != null) {
            try {
                int n = Integer.parseInt(str);
                if (n < 1) {
                    throw new NumberFormatException();
                }
                this.maxConnections = n;
                this.connectionsLabel.setText(this.currentConnections + "/" + this.maxConnections);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, "Must be an integer > 0.", "Error", 0);
            }
        }
    }

    private void startServerMenuItemActionPerformed(ActionEvent evt) {
        try {
            this.open();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void stopServerMenuItemActionPerformed(ActionEvent evt) {
        try {
            this.closeServer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.portMenuItem.setEnabled(true);
            this.startServerMenuItem.setEnabled(true);
            this.startMI.setEnabled(true);
            this.stopServerMenuItem.setEnabled(false);
            this.stopMI.setEnabled(false);
            this.serverStatusLabel.setToolTipText("Server stopped");
            this.serverStatusLabel.setIcon(STOPPED_ICON);
            this.authenticateCheckBox.setEnabled(true);
        }
    }

    private void portMenuItemActionPerformed(ActionEvent evt) {
        String str = JOptionPane.showInputDialog(this, "Enter port number for TCP/IP connection:", "" + this.port);
        if (str != null) {
            try {
                int n = Integer.parseInt(str);
                if (0 >= n || n >= 65533) {
                    throw new NumberFormatException();
                }
                this.port = n;
                this.portLabel.setText("" + this.port);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, "Port must be an integer < 65532.", "Error creating port", 0);
            }
        }
    }

    public static IPServer getIPServerReference() {
        return ipRef;
    }

    public boolean isRotorConnected(String name) {
        Iterator<SerialRotor> itr = this.rotors.iterator();
        while (itr.hasNext()) {
            if (!itr.next().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exitMenuItemActionPerformed(ActionEvent evt) {
        int option = JOptionPane.showConfirmDialog(this, "Are you sure you wish to close the the Server?", "Close Program", 0);
        if (option != 0) return;
        try {
            this.closeAllConnections();
            this.serverSocket.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            try {
                this.saveSettings();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (this.rotorUI != null) {
                    this.rotorUI.shutDown();
                }
                System.exit(0);
            }
        }
    }

    private void localControllerMenuItemActionPerformed(ActionEvent evt) {
        this.rotorUI = RotorUI.getInstance((int)this.port);
        this.rotorUI.setVisible(true);
    }

    private void closeAllConnections() {
        while (!connections.isEmpty()) {
            for (int i = 0; i < connections.size(); ++i) {
                ClientServiceThread thread = connections.get(i);
                thread.closeClient();
                connections.remove(thread);
            }
        }
    }

    public void open() throws IOException {
        try {
            this.serverSocket = new ServerSocket(this.port);
            this.portMenuItem.setEnabled(false);
            this.startServerMenuItem.setEnabled(false);
            this.startMI.setEnabled(false);
            this.stopServerMenuItem.setEnabled(true);
            this.stopMI.setEnabled(true);
            this.authenticateCheckBox.setEnabled(false);
            this.serverStatusLabel.setToolTipText("Server Running");
            this.serverStatusLabel.setIcon(RUNNING_ICON);
            this.displayText("Server started.");
            SwingWorker swingWorker = new SwingWorker(){

                @Override
                public Object construct() {
                    boolean id = false;
                    while (!IPServer.this.serverSocket.isClosed()) {
                        try {
                            Socket clientSocket = IPServer.this.serverSocket.accept();
                            String addrString = clientSocket.getInetAddress().getHostAddress();
                            ClientServiceThread clientThread = new ClientServiceThread(clientSocket, addrString);
                            clientThread.start();
                            if (connections.size() < IPServer.this.maxConnections) {
                                boolean addIt = true;
                                for (int i = 0; i < connections.size(); ++i) {
                                    if (!((ClientServiceThread)connections.get(i)).getClientID().equals(addrString)) continue;
                                }
                                if (!addIt) continue;
                                connections.add(clientThread);
                                IPServer.this.currentConnections = connections.size();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        IPServer.this.connectionsLabel.setText(IPServer.this.currentConnections + "/" + IPServer.this.maxConnections);
                                    }
                                });
                                IPServer.this.updateConnectedList();
                                continue;
                            }
                            clientThread.closeClient();
                        }
                        catch (SocketException se) {
                            se.printStackTrace();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                    return "blah";
                }
            };
        }
        catch (BindException be) {
            JOptionPane.showMessageDialog(this, "Could not open port " + this.port + "." + '\n' + "It may be in use by another program.", "Error", 2);
            this.serverStatusLabel.setIcon(STOPPED_ICON);
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void closeServer() {
        try {
            this.closeAllConnections();
            this.serverSocket.close();
            this.displayText("Server stopped.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateClients(String rotorName, double degrees, char status, int remoteRSSI) {
        for (int i = 0; i < connections.size(); ++i) {
            ClientServiceThread thread = connections.get(i);
            thread.updateClient(rotorName, degrees, status, remoteRSSI);
        }
    }

    public void updateStackMatchClients(String smName, boolean[] ants, int status, int remoteRSSI) {
        for (int i = 0; i < connections.size(); ++i) {
            ClientServiceThread thread = connections.get(i);
            thread.updateSMClient(smName, ants, status, remoteRSSI);
        }
    }

    public void updateSwitchClients(String swName, String position, int status, int remoteRSSI) {
        for (int i = 0; i < connections.size(); ++i) {
            ClientServiceThread thread = connections.get(i);
            thread.updateSwitchClient(swName, position, status, remoteRSSI);
        }
    }

    public void updateStatus(String rotorName, char status) {
        for (int i = 0; i < connections.size(); ++i) {
            ClientServiceThread clientServiceThread = connections.get(i);
        }
    }

    public synchronized void addRotor(SerialRotor rotor) {
        List<Object> l = Arrays.asList(this.listenerList.getListenerList());
        if (!l.contains(rotor)) {
            this.displayText("ROTOR CONNECTED: \t" + rotor.getName());
            this.addRotorCommandListener(rotor);
            this.addRotorQueryListener(rotor);
            this.addRotorStopListener(rotor);
            rotor.addRotorEventListener(this);
            this.rotors.add(rotor);
            for (int i = 0; i < connections.size(); ++i) {
                ClientServiceThread thread = connections.get(i);
                thread.addRotor(rotor.getName());
            }
            try {
                rotor.queryPosition();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public synchronized void removeRotor(SerialRotor rotor) {
        this.displayText("ROTOR DISCONNECTED: \t" + rotor.getName());
        this.removeRotorCommandListener(rotor);
        this.removeRotorStopListener(rotor);
        this.removeRotorQueryListener(rotor);
        rotor.removeRotorEventListener(this);
        this.rotors.remove(rotor);
        for (int i = 0; i < connections.size(); ++i) {
            ClientServiceThread thread = connections.get(i);
            thread.removeRotor(rotor.getName());
        }
    }

    public void addStackMatch(IWioStackMatch sm) {
        int i;
        this.displayText("STACK SWITCH CONNECTED: \t");
        sm.addStackMatchListener(this);
        String[] names = sm.getName().split(",");
        for (i = 0; i < names.length; ++i) {
            this.stackMatches.put(names[i].toLowerCase(), sm);
            this.displayText("    " + names[i]);
        }
        for (i = 0; i < connections.size(); ++i) {
            ClientServiceThread thread = connections.get(i);
            thread.addStackMatch(sm);
        }
        sm.initializeStack();
    }

    public void removeStackMatch(IWioStackMatch sm) {
        int i;
        sm.removeStackMatchListener(this);
        this.displayText("STACK SWITCH DISCONNECTED: \t");
        String[] names = sm.getName().split(",");
        for (i = 0; i < names.length; ++i) {
            this.stackMatches.remove(names[i].toLowerCase());
        }
        for (i = 0; i < connections.size(); ++i) {
            ClientServiceThread thread = connections.get(i);
            thread.removeStackMatch(sm);
        }
    }

    public void addWioSwitch(IWioSwitch sw) {
        sw.addWioSwitchListener(this);
        String name = sw.getName();
        this.displayText("SWITCH CONNECTED: \t" + name);
        this.wioSwitches.put(name, sw);
        if (sw.getModel().isMatrixLockout()) {
            this.displayText("MLOCKED SWITCH CONNECTED: \t" + name);
            this.mLockedWioSwitches.add(name);
        }
        for (int i = 0; i < connections.size(); ++i) {
            ClientServiceThread thread = connections.get(i);
            thread.addWioSwitch(sw);
        }
    }

    public static String getUserDirectory() {
        return System.getProperty("user.home") + System.getProperty("file.separator") + "Documents" + System.getProperty("file.separator") + "GH Everyware Server" + System.getProperty("file.separator");
    }

    public void removeWioSwitch(IWioSwitch sw) {
        sw.addWioSwitchListener(this);
        String name = sw.getName();
        this.displayText("SWITCH DISCONNECTED: \t" + name);
        this.wioSwitches.remove(name);
        if (sw.getModel().isMatrixLockout()) {
            this.displayText("MLOCKED SWITCH DISCONNECTED: \t" + name);
            this.mLockedWioSwitches.remove(name);
        }
        for (int i = 0; i < connections.size(); ++i) {
            ClientServiceThread thread = connections.get(i);
            thread.removeWioSwitch(sw);
        }
    }

    public void updateClientPresets() {
        for (int i = 0; i < connections.size(); ++i) {
            ClientServiceThread thread = connections.get(i);
            thread.sendPresets(this.locationsString);
        }
    }

    public boolean checkValidity(String challengeText, String user, byte[] clientBytes) {
        byte[] localPass = this.pmd.getPassword(user);
        if (localPass == null) {
            return false;
        }
        try {
            MessageDigest.getInstance("SHA-256");
            this.md.update(user.getBytes());
            this.md.update(challengeText.getBytes());
            this.md.update(localPass);
            byte[] dig = this.md.digest();
            String digest = new String(dig);
            String passTry = new String(clientBytes);
            this.md.reset();
            return Arrays.equals(dig, clientBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void updateConnectedList() {
    }

    private void updatePresets(File f) {
        String str = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(f));
            boolean eof = false;
            while (!eof) {
                String s = bufferedReader.readLine();
                if (s == null) {
                    eof = true;
                    continue;
                }
                str = str + s + '\n';
            }
            bufferedReader.close();
        }
        catch (Exception bufferedReader) {
            // empty catch block
        }
        String[] strs1 = str.split("\n");
        String locString = "LOCATIONS";
        for (int i = 0; i < strs1.length; ++i) {
            String[] strs2 = strs1[i].split(":");
            if (strs2.length != 3) continue;
            locString = locString + US + strs2[0];
            double latitude = Double.NaN;
            double longitude = Double.NaN;
            try {
                longitude = Double.parseDouble(strs2[1]);
                latitude = Double.parseDouble(strs2[2]);
                presetsMap.put(strs2[0], new Point2D.Double(latitude, longitude));
                continue;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        this.locationsString = locString;
        this.updateClientPresets();
    }

    public void displayText(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String str = text.replaceAll(IPServer.US, " ");
                str = str.replaceAll("\u001e", " ");
                if (IPServer.this.networkTextArea.getLineCount() > 1000) {
                    IPServer.this.networkTextArea.setText("");
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM YYYY  HH:mm:ss");
                Date date = new Date();
                IPServer.this.networkTextArea.append(str + "    " + dateFormat.format(date) + System.lineSeparator());
                IPServer.this.networkTextArea.setCaretPosition(IPServer.this.networkTextArea.getDocument().getLength());
                if (IPServer.this.serverLogFileCheckBox.isSelected()) {
                    File file = new File(IPServer.getUserDirectory() + "ServerLog.txt");
                    PrintWriter printWriter = null;
                    String fileContent = dateFormat.format(date) + "  " + str + System.lineSeparator();
                    try {
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        printWriter = new PrintWriter(new FileOutputStream(file, true));
                        printWriter.write(fileContent);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        printWriter.flush();
                        printWriter.close();
                    }
                }
            }
        });
    }

    private void saveSettings() throws IOException {
        Properties prop = new Properties();
        File file = new File(IPServer.getUserDirectory() + "settings_server.ini");
        if (!file.exists()) {
            file.createNewFile();
        }
        prop.load(new FileInputStream(file));
        prop.put("port", "" + this.port);
        prop.put("maxConnections", "" + this.maxConnections);
        prop.put("lat", "" + this.lat);
        prop.put("lon", "" + this.lon);
        prop.put("authenticate", "" + this.authenticateCheckBox.isSelected());
        prop.put("serverLogging", "" + this.serverLogFileCheckBox.isSelected());
        if (this.rotorUI != null && this.rotorUI.isVisible()) {
            prop.put("rotorUiVisible", "true");
        } else {
            prop.put("rotorUiVisible", "false");
        }
        prop.put("serverWindowWidth", "" + this.getWidth());
        prop.put("serverWindowHeight", "" + this.getHeight());
        prop.put("serverWindowX", "" + this.getX());
        prop.put("serverWindowY", "" + this.getY());
        prop.put("serverMinimized", "" + this.serverMinimizedCheckBox.isSelected());
        try {
            this.rotorManager.saveSettings();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        prop.store(new FileOutputStream(file), "Settings for server UI");
    }

    private void loadSettings() throws IOException {
        Properties prop = new Properties();
        File file = new File(IPServer.getUserDirectory() + "settings_server.ini");
        if (!file.exists()) {
            file.createNewFile();
        }
        prop.load(new FileInputStream(file));
        this.port = new Integer(prop.getProperty("port", "17220"));
        this.maxConnections = new Integer(prop.getProperty("maxConnections", "4"));
        this.lat = new Double(prop.getProperty("lat", "0.0"));
        this.lon = new Double(prop.getProperty("lon", "0.0"));
        this.authenticateOnStartup = new Boolean(prop.getProperty("authenticate", "false"));
        this.serverLoggingOnStartup = new Boolean(prop.getProperty("serverLogging", "false"));
        this.rotorUiVisible = new Boolean(prop.getProperty("rotorUiVisible", "false"));
        frameWidth = new Integer(prop.getProperty("serverWindowWidth", "500"));
        frameHeight = new Integer(prop.getProperty("serverWindowHeight", "200"));
        frameX = new Integer(prop.getProperty("serverWindowX", "0"));
        frameY = new Integer(prop.getProperty("serverWindowY", "0"));
        serverMinimizedOnStartup = new Boolean(prop.getProperty("serverMinimized", "false"));
    }

    private void loadLicense(File file) {
        FileInputStream fis = null;
        ObjectInputStream in = null;
        if (!file.exists()) {
            System.out.println("no extensions loaded");
            return;
        }
        try {
            fis = new FileInputStream(file);
            in = new ObjectInputStream(fis);
            this.licenseInfo = (LicenseInfo)in.readObject();
        }
        catch (Exception e) {
            System.out.println("License file not readable");
        }
    }

    private void loadMasterPass(File file) {
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(file);
            in = new ObjectInputStream(fis);
            masterPass = (byte[])in.readObject();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage() + '\n' + '\n' + "Unable to load password file.  The file may " + '\n' + "be missing or corrupt.  Please reinstall program.", "Password Error", 0);
        }
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void rotorEventOccurred(RotorEvent evt) {
        SerialRotor rotor = (SerialRotor)evt.getSource();
        String name = rotor.getName();
        Double heading = evt.getHeading();
        char status = evt.getStatus();
        int remoteRSSI = evt.getRemoteRSSI();
        this.updateClients(name, heading, status, remoteRSSI);
    }

    @Override
    public void stackMatchUpdate(IWioStackMatch stackMatch, boolean[] ants, int status, int remoteRSSI) {
        this.updateStackMatchClients(stackMatch.getName(), ants, status, remoteRSSI);
    }

    @Override
    public void wioSwitchUpdate(IWioSwitch sw, String state, int status, int remoteRSSI) {
        this.updateSwitchClients(sw.getName(), state, status, remoteRSSI);
    }

    public void addRotorCommandListener(RotorCommandListener listener) {
        this.listenerList.add(RotorCommandListener.class, listener);
    }

    public void removeRotorCommandListener(RotorCommandListener listener) {
        this.listenerList.remove(RotorCommandListener.class, listener);
    }

    public void addRotorStopListener(RotorStopListener listener) {
        this.listenerList.add(RotorStopListener.class, listener);
    }

    public void removeRotorStopListener(RotorStopListener listener) {
        this.listenerList.remove(RotorStopListener.class, listener);
    }

    public void addRotorQueryListener(RotorQueryListener listener) {
        this.listenerList.add(RotorQueryListener.class, listener);
    }

    public void removeRotorQueryListener(RotorQueryListener listener) {
        this.listenerList.remove(RotorQueryListener.class, listener);
    }

    public void fireRotorCommandEvent(RotorCommandEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != RotorCommandListener.class) continue;
            ((RotorCommandListener)listeners[i + 1]).rotorCommandOccurred(evt);
        }
    }

    public void fireRotorStopEvent(RotorStopEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != RotorStopListener.class) continue;
            ((RotorStopListener)listeners[i + 1]).rotorStopEventOccurred(evt);
        }
    }

    public void fireRotorQueryEvent(RotorQueryEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != RotorQueryListener.class) continue;
            ((RotorQueryListener)listeners[i + 1]).rotorQueryOccurred(evt);
        }
    }

    private void updateMemory() {
        long heap = Runtime.getRuntime().totalMemory() / 1000L;
        long total = Runtime.getRuntime().maxMemory() / 1000L;
        this.memLabel.setText(heap + " kB / " + total + " kB (" + (int)((double)heap / (double)total * 100.0) + "%)");
    }

    private String getChallengeText() {
        return "" + Math.random() + "" + System.nanoTime() * System.currentTimeMillis() + "" + new Date().getTime();
    }

    public static byte[] getMasterPass() {
        return masterPass;
    }

    static /* synthetic */ JCheckBoxMenuItem access$3600(IPServer x0) {
        return x0.authenticateCheckBox;
    }

    static {
        frameWidth = 500;
        frameHeight = 200;
        frameX = 0;
        frameY = 0;
        serverMinimizedOnStartup = false;
        IPServerDelayFlag = false;
    }

    class ClientServiceThread
    extends Thread {
        Socket clientSocket;
        InetAddress clientAddress;
        String clientID = "";
        String challengeText;
        String user = "";
        boolean runThread = true;
        boolean userEntered = !IPServer.access$3600(IPServer.this).isSelected();
        boolean authenticated = !IPServer.access$3600(IPServer.this).isSelected();
        InputStream inStream;
        BufferedReader in;
        PrintWriter out;
        private Timer authTimer;
        Date startTime;

        ClientServiceThread(Socket s, String clientID) {
            this.clientSocket = s;
            this.clientAddress = this.clientSocket.getInetAddress();
            this.clientID = clientID;
            this.startTime = new Date();
            this.authTimer = new Timer(5000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ClientServiceThread.this.timeoutOccurred();
                }
            });
            this.authTimer.setInitialDelay(5000);
            this.authTimer.setRepeats(false);
            try {
                IPServer.this.md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException ex) {
                ex.printStackTrace();
            }
            try {
                this.inStream = this.clientSocket.getInputStream();
                this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                this.out = new PrintWriter(new OutputStreamWriter(this.clientSocket.getOutputStream()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void closeSocket() {
            try {
                IPServer.this.displayText("Disconnecting: \t\t" + this.clientSocket.getInetAddress().getHostAddress());
                this.runThread = false;
                this.clientSocket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                IPServer.this.updateConnectedList();
            }
        }

        public void updateClient(String rotorName, double degrees, char status, int remoteRSSI) {
            if (this.authenticated) {
                this.out.println("POINT\u001f" + rotorName + IPServer.US + degrees + IPServer.US + "" + status + "" + IPServer.US + "" + remoteRSSI);
                this.out.flush();
            }
        }

        public void updateSMClient(String smName, boolean[] ants, int status, int remoteRSSI) {
            if (this.authenticated) {
                String command = "STACK\u001f" + smName + IPServer.US + ants[0] + IPServer.US + ants[1] + IPServer.US + ants[2] + IPServer.US + ants[3] + IPServer.US + "" + status + "" + IPServer.US + "" + remoteRSSI;
                this.out.println(command);
                this.out.flush();
            }
        }

        public void sendPopupMessage(String text) {
            if (this.authenticated) {
                this.out.println("POPUP\u001f" + text);
                this.out.flush();
            }
        }

        public void closeClient() {
            this.out.println("CLOSE");
            this.out.flush();
            this.runThread = false;
        }

        public String getClientID() {
            return this.clientID;
        }

        public void addRotor(String rotorName) {
            if (this.authenticated) {
                this.out.println("ADD\u001f" + rotorName);
                this.out.flush();
            }
        }

        public void removeRotor(String rotorName) {
            if (this.authenticated) {
                this.out.println("REMOVE\u001f" + rotorName);
                this.out.flush();
            }
        }

        public void timeoutOccurred() {
            IPServer.this.displayText("Auth Timout: \t \t" + this.getClientID());
            try {
                this.clientSocket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                connections.remove(this);
            }
        }

        private void addStackMatch(IWioStackMatch sm) {
            String command = "STACKADD\u001f" + sm.getName();
            this.out.println(command);
            this.out.flush();
        }

        private void addWioSwitch(IWioSwitch sw) {
            Vector posNames = sw.getPositionNames();
            String str = "";
            if (sw.getModel().getDisplayType() == 3) {
                WioSwitchModel m = (WioSwitchModel)sw.getModel();
                for (int i = 0; i < posNames.size(); ++i) {
                    str = str + IPServer.US + (String)posNames.get(i) + IPServer.GS + m.getLowerFreq((String)posNames.get(i)) + "" + IPServer.GS + "" + m.getUpperFreq((String)posNames.get(i)) + "";
                }
            } else {
                for (int i = 0; i < posNames.size(); ++i) {
                    str = str + IPServer.US + (String)posNames.get(i) + IPServer.GS + sw.getModel().getHeading((String)posNames.get(i)) + "" + IPServer.GS + "" + sw.getModel().getBeamwidth((String)posNames.get(i)) + "" + IPServer.GS + "" + sw.getModel().isBidirectional((String)posNames.get(i));
                }
            }
            if (this.authenticated) {
                System.out.println("Sending: SWITCHADD\u001f" + sw.getModel().getDisplayType() + "" + IPServer.US + sw.getName() + str);
                this.out.println("SWITCHADD\u001f" + sw.getModel().getDisplayType() + "" + IPServer.US + sw.getName() + str);
                this.out.flush();
            }
        }

        private void removeStackMatch(IWioStackMatch sm) {
            String command = "STACKREMOVE\u001f" + sm.getName();
            this.out.println(command);
            this.out.flush();
        }

        private void removeWioSwitch(IWioSwitch sw) {
            if (this.authenticated) {
                this.out.println("SWITCHREMOVE\u001f" + sw.getName());
                this.out.flush();
            }
        }

        private void sendPresets(String presetsString) {
            if (this.authenticated) {
                this.out.println(presetsString);
                this.out.flush();
            }
        }

        public Date getStartTime() {
            return this.startTime;
        }

        @Override
        public String toString() {
            return this.clientSocket.getInetAddress().getHostAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block79: {
                boolean byteCounter = false;
                IPServer.this.displayText("Accepted New Client : \t \t" + this.clientID);
                if (this.authenticated) {
                    for (SerialRotor r : IPServer.this.rotors) {
                        this.addRotor(r.getName());
                        r.queryPosition();
                    }
                    Collection switches = IPServer.this.wioSwitches.values();
                    Iterator itr = switches.iterator();
                    while (itr.hasNext()) {
                        this.addWioSwitch((IWioSwitch)itr.next());
                    }
                    Collection sms = IPServer.this.stackMatches.values();
                    Iterator itr2 = sms.iterator();
                    while (itr2.hasNext()) {
                        this.addStackMatch((IWioStackMatch)itr2.next());
                    }
                } else {
                    this.out.println("USER:");
                    this.out.flush();
                    this.authTimer.start();
                }
                while (this.runThread) {
                    boolean b = false;
                    byte[] array = new byte[256];
                    boolean counter = false;
                    int size = this.inStream.read(array);
                    if (size <= -1) break;
                    byte[] bytes = new byte[size];
                    for (int i = 0; i < size; ++i) {
                        bytes[i] = array[i];
                    }
                    String clientCommandRaw = new String(bytes).trim();
                    if (clientCommandRaw.equals("")) continue;
                    if (!this.authenticated) {
                        if (!this.userEntered) {
                            this.user = clientCommandRaw;
                            this.userEntered = true;
                            this.challengeText = IPServer.this.getChallengeText();
                            this.out.println("PASS:" + this.challengeText);
                            this.out.flush();
                            continue;
                        }
                        if (IPServer.this.checkValidity(this.challengeText, this.user, bytes)) {
                            this.authTimer.stop();
                            this.authenticated = true;
                            for (SerialRotor r : IPServer.this.rotors) {
                                this.addRotor(r.getName());
                            }
                            Collection switches = IPServer.this.wioSwitches.values();
                            Iterator itr = switches.iterator();
                            while (itr.hasNext()) {
                                this.addWioSwitch((IWioSwitch)itr.next());
                            }
                            Collection sms = IPServer.this.stackMatches.values();
                            Iterator itr2 = sms.iterator();
                            while (itr2.hasNext()) {
                                this.addStackMatch((IWioStackMatch)itr2.next());
                            }
                            IPServer.this.updateClientPresets();
                            IPServer.this.displayText("Authorized Client : \t \t" + this.clientID + " " + this.user);
                            continue;
                        }
                        this.out.println("INVALID USER/PASS");
                        this.out.flush();
                        IPServer.this.displayText("Invalid user/pass: \t \t" + this.clientID);
                        this.out.println("CLOSE");
                        this.out.flush();
                        this.clientSocket.close();
                        connections.remove(this);
                        continue;
                    }
                    this.authTimer.stop();
                    String[] clientCommand = clientCommandRaw.split("\n");
                    System.out.println(clientCommandRaw);
                    for (int j = 0; j < clientCommand.length; ++j) {
                        String[] strs;
                        double degrees;
                        String rotor;
                        String[] strs22;
                        String[] commands;
                        IPServer.this.displayText(clientCommand[j] + "\t \t" + this.clientID);
                        if (clientCommand[j].startsWith("TURN")) {
                            commands = clientCommand[j].split("\r");
                            for (int i = 0; i < commands.length; ++i) {
                                strs22 = commands[i].split(IPServer.US);
                                rotor = strs22[1].trim();
                                if (IPServer.this.lockedRotorsMap.get(rotor) != null && !((InetAddress)IPServer.this.lockedRotorsMap.get(rotor)).equals(this.clientAddress)) continue;
                                try {
                                    if (strs22.length <= 2) continue;
                                    if ("CW".equals(strs22[2])) {
                                        IPServer.this.fireRotorCommandEvent(new RotorCommandEvent((Object)this, rotor, RotorCommandEvent.TURN_CW));
                                        continue;
                                    }
                                    if ("CCW".equals(strs22[2])) {
                                        IPServer.this.fireRotorCommandEvent(new RotorCommandEvent((Object)this, rotor, RotorCommandEvent.TURN_CCW));
                                        continue;
                                    }
                                    strs22[2] = strs22[2].replace(",", ".");
                                    degrees = Double.parseDouble(strs22[2]);
                                    IPServer.this.fireRotorCommandEvent(new RotorCommandEvent((Object)this, rotor, degrees));
                                    continue;
                                }
                                catch (NumberFormatException nfe) {
                                    nfe.printStackTrace();
                                }
                            }
                        } else if (clientCommand[j].startsWith("SET_STACK")) {
                            try {
                                commands = clientCommand[j].split("\r");
                                for (int i = 0; i < commands.length; ++i) {
                                    strs22 = commands[i].split(IPServer.US);
                                    rotor = strs22[1].trim();
                                    boolean newState = Boolean.parseBoolean(strs22[2]);
                                    ((IWioStackMatch)IPServer.this.stackMatches.get(rotor.toLowerCase())).setAntenna(rotor, newState);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if (clientCommand[j].startsWith("SET_SWITCH")) {
                            try {
                                commands = clientCommand[j].split("\r");
                                for (int i = 0; i < commands.length; ++i) {
                                    strs22 = commands[i].split(IPServer.US);
                                    String switchName = strs22[1];
                                    String position = strs22[2];
                                    Boolean lockedSwitchPosition = false;
                                    if (IPServer.this.mLockedWioSwitches.contains(switchName)) {
                                        for (String name : IPServer.this.mLockedWioSwitches) {
                                            if (!((IWioSwitch)IPServer.this.wioSwitches.get(name)).getState().equalsIgnoreCase(position)) continue;
                                            lockedSwitchPosition = true;
                                            IPServer.this.displayText("SET_SWITCH LOCKOUT " + position);
                                        }
                                    }
                                    boolean state = true;
                                    if (lockedSwitchPosition.booleanValue() && !position.equalsIgnoreCase("OFF")) continue;
                                    if (strs22.length > 3) {
                                        state = Boolean.parseBoolean(strs22[3]);
                                        ((IWioSwitch)IPServer.this.wioSwitches.get(switchName)).setState(position, state);
                                        continue;
                                    }
                                    if (((IWioSwitch)IPServer.this.wioSwitches.get(switchName)).isVirtualSwitch()) {
                                        Iterator itr = ((IWioSwitch)IPServer.this.wioSwitches.get(switchName)).getVirtualSwitches().iterator();
                                        while (itr.hasNext()) {
                                            String[] strArray = new String[3];
                                            strArray = (String[])itr.next();
                                            if (!strArray[0].equals(position)) continue;
                                            try {
                                                if (strArray[2].charAt(0) == '#') {
                                                    String degreeString = strArray[2].substring(1, strArray[2].length());
                                                    double degrees2 = Double.parseDouble(degreeString);
                                                    IPServer.this.fireRotorCommandEvent(new RotorCommandEvent((Object)this, strArray[1], degrees2));
                                                } else if (strArray[2].charAt(0) == '$') {
                                                    SimpleTcpUdpClient simpleClient;
                                                    String commandString = strArray[2];
                                                    commandString = strArray[2].replace("\\r", "\r");
                                                    commandString = commandString.replace("\\n", "\n");
                                                    if (strArray[1].toUpperCase().startsWith("TCP:")) {
                                                        simpleClient = new SimpleTcpUdpClient();
                                                        String ipSocketStr = strArray[1].substring(strArray[1].indexOf(":") + 1);
                                                        if (!simpleClient.sendViaTCP(ipSocketStr, commandString)) {
                                                            IPServer.this.displayText("TCP Socket Error " + ipSocketStr);
                                                        }
                                                    } else if (strArray[1].toUpperCase().startsWith("UDP:")) {
                                                        String ipSocketStr = strArray[1].substring(strArray[1].indexOf(":") + 1);
                                                        simpleClient = new SimpleTcpUdpClient();
                                                        simpleClient.sendViaUDP(ipSocketStr, commandString);
                                                    } else {
                                                        IPServer.this.fireRotorCommandEvent(new RotorCommandEvent((Object)this, strArray[1], commandString));
                                                    }
                                                } else {
                                                    Boolean aVirtuallockedSwitchPosition = false;
                                                    if (IPServer.this.mLockedWioSwitches.contains(strArray[1])) {
                                                        for (String name : IPServer.this.mLockedWioSwitches) {
                                                            if (!((IWioSwitch)IPServer.this.wioSwitches.get(name)).getState().equalsIgnoreCase(strArray[2])) continue;
                                                            aVirtuallockedSwitchPosition = true;
                                                            IPServer.this.displayText("SET_SWITCH LOCKOUT " + position);
                                                        }
                                                    }
                                                    if (!aVirtuallockedSwitchPosition.booleanValue()) {
                                                        ((IWioSwitch)IPServer.this.wioSwitches.get(strArray[1])).setState(strArray[2]);
                                                    }
                                                }
                                            }
                                            catch (NullPointerException e) {
                                                IPServer.this.displayText("***ERROR*** " + strArray[1] + " Device is Not Connected");
                                            }
                                            IPServer.this.displayText("      SET VIRTUAL " + strArray[1] + " To " + strArray[2]);
                                        }
                                    }
                                    ((IWioSwitch)IPServer.this.wioSwitches.get(switchName)).setState(position);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (clientCommand[j].startsWith("TO_DEC")) {
                            try {
                                strs = clientCommand[j].split(IPServer.US);
                                String rotor2 = strs[1].trim();
                                strs[2] = strs[2].replace(",", ".");
                                strs[3] = strs[3].replace(",", ".");
                                Double targetLat = Double.parseDouble(strs[2]);
                                Double targetLon = Double.parseDouble(strs[3]);
                                degrees = TrigUtils.getHeading(IPServer.this.lat, IPServer.this.lon, targetLat, targetLon);
                                IPServer.this.fireRotorCommandEvent(new RotorCommandEvent((Object)this, rotor2, degrees));
                            }
                            catch (NumberFormatException nfe) {
                                IPServer.this.displayText(nfe.getMessage() + " " + clientCommand + " " + this.clientID);
                            }
                        }
                        if (clientCommand[j].startsWith("TO_PRESET")) {
                            strs = clientCommand[j].split(IPServer.US);
                            String rotor3 = strs[1];
                            String preset = strs[2];
                            Point2D.Double loc = (Point2D.Double)presetsMap.get(preset);
                            if (loc != null) {
                                degrees = TrigUtils.getHeading(IPServer.this.lat, IPServer.this.lon, loc.y, loc.x);
                                IPServer.this.fireRotorCommandEvent(new RotorCommandEvent((Object)this, rotor3, degrees));
                            }
                        }
                        if (clientCommand[j].startsWith("STOP")) {
                            commands = clientCommand[j].split("\r");
                            for (int i = 0; i < commands.length; ++i) {
                                strs22 = commands[i].split(IPServer.US);
                                try {
                                    if (strs22.length <= 1) continue;
                                    rotor = strs22[1].trim();
                                    if (IPServer.this.lockedRotorsMap.get(rotor) != null && !((InetAddress)IPServer.this.lockedRotorsMap.get(rotor)).equals(this.clientAddress)) continue;
                                    IPServer.this.fireRotorStopEvent(new RotorStopEvent(this, rotor));
                                    continue;
                                }
                                catch (NumberFormatException nfe) {
                                    nfe.printStackTrace();
                                }
                            }
                            continue;
                        }
                        if (clientCommand[j].startsWith("LOCK")) {
                            strs = clientCommand[j].split(IPServer.US);
                            String rotor4 = strs[1];
                            if (IPServer.this.lockedRotorsMap.get(rotor4) != null && !((InetAddress)IPServer.this.lockedRotorsMap.get(rotor4)).equals(this.clientAddress)) continue;
                            IPServer.this.lockedRotorsMap.put(rotor4, this.clientAddress);
                            continue;
                        }
                        if (clientCommand[j].startsWith("UNLOCK")) {
                            strs = clientCommand[j].split(IPServer.US);
                            String rotor5 = strs[1];
                            if (IPServer.this.lockedRotorsMap.get(rotor5) != null && !((InetAddress)IPServer.this.lockedRotorsMap.get(rotor5)).equals(this.clientAddress)) continue;
                            IPServer.this.lockedRotorsMap.remove(rotor5);
                            continue;
                        }
                        if (clientCommand[j].startsWith("GETHEAD")) {
                            strs = clientCommand[j].split(" ");
                            IPServer.this.fireRotorQueryEvent(new RotorQueryEvent(this, strs[1]));
                            continue;
                        }
                        if (clientCommand[j].startsWith("GET_LOCATIONS")) {
                            IPServer.this.updateClientPresets();
                            continue;
                        }
                        if (clientCommand[j].startsWith("QUIT")) {
                            IPServer.this.displayText("Disconnecting: \t \t" + this.clientID);
                            this.runThread = false;
                            connections.remove(this);
                            continue;
                        }
                        if (!clientCommand[j].startsWith("RESTART")) continue;
                        IPServer.this.stopServerMenuItem.doClick();
                        IPServer.this.startServerMenuItem.doClick();
                    }
                }
                IPServer.this.displayText("Client Disconnected \t \t" + this.clientID);
                Object[] rotors = IPServer.this.lockedRotorsMap.keySet().toArray();
                for (int i = 0; i < rotors.length; ++i) {
                    if (rotors[i] instanceof String) {
                        if (!this.clientAddress.equals(IPServer.this.lockedRotorsMap.get(rotors[i]))) continue;
                        IPServer.this.lockedRotorsMap.remove(rotors[i]);
                        continue;
                    }
                    System.out.println("!!!");
                }
                connections.remove(this);
                IPServer.this.updateConnectedList();
                IPServer.this.currentConnections = connections.size();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IPServer.this.connectionsLabel.setText(IPServer.this.currentConnections + "/" + IPServer.this.maxConnections);
                    }
                });
                IPServer.this.updateConnectedList();
                try {
                    this.clientSocket.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                break block79;
                catch (Exception e) {
                    e.printStackTrace();
                    IPServer.this.displayText("Client Disconnected \t \t" + this.clientID);
                    rotors = IPServer.this.lockedRotorsMap.keySet().toArray();
                    for (int i = 0; i < rotors.length; ++i) {
                        if (rotors[i] instanceof String) {
                            if (!this.clientAddress.equals(IPServer.this.lockedRotorsMap.get(rotors[i]))) continue;
                            IPServer.this.lockedRotorsMap.remove(rotors[i]);
                            continue;
                        }
                        System.out.println("!!!");
                    }
                    connections.remove(this);
                    IPServer.this.updateConnectedList();
                    IPServer.this.currentConnections = connections.size();
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    IPServer.this.updateConnectedList();
                    try {
                        this.clientSocket.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        IPServer.this.displayText("Client Disconnected \t \t" + this.clientID);
                        Object[] rotors2 = IPServer.this.lockedRotorsMap.keySet().toArray();
                        for (int i = 0; i < rotors2.length; ++i) {
                            if (rotors2[i] instanceof String) {
                                if (!this.clientAddress.equals(IPServer.this.lockedRotorsMap.get(rotors2[i]))) continue;
                                IPServer.this.lockedRotorsMap.remove(rotors2[i]);
                                continue;
                            }
                            System.out.println("!!!");
                        }
                        connections.remove(this);
                        IPServer.this.updateConnectedList();
                        IPServer.this.currentConnections = connections.size();
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        IPServer.this.updateConnectedList();
                        try {
                            this.clientSocket.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                        throw throwable;
                    }
                }
            }
        }

        private void updateSwitchClient(String swName, String position, int status, int remoteRSSI) {
            CharSequence command;
            if (this.authenticated) {
                command = "SWITCHUPDATE\u001f" + swName + IPServer.US + position + IPServer.US + "" + status + "" + IPServer.US + "" + remoteRSSI;
                this.out.println((String)command);
                this.out.flush();
            }
            if (IPServer.this.mLockedWioSwitches.contains(swName)) {
                command = new StringBuilder(255);
                ((StringBuilder)command).append("SWITCHLOCKS\u001f" + swName);
                for (String name : IPServer.this.mLockedWioSwitches) {
                    ((StringBuilder)command).append(IPServer.US + ((IWioSwitch)IPServer.this.wioSwitches.get(name)).getState());
                }
                this.out.println(command);
                this.out.flush();
            }
        }
    }
}

