/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.gh_everyware_server.switchEditor;

import com.ghe.gh_everyware_server.switchEditor.SwitchStatePanel;
import com.ghe.gh_everyware_server.switchEditor.VirtualPositionsDialog;
import com.ghe.gh_everyware_server.switchEditor.WioSwitchEditor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class SwitchEntryPanel
extends JPanel {
    final ButtonGroup buttonGroup;
    public WioSwitchEditor editor;
    private String savedPositionName = null;
    private JCheckBox bidirectionalCheckBox;
    private JTextField bwTextField;
    private JButton expandVirtualPosition;
    private JTextField headingTextField;
    private JRadioButton initialRadioButton;
    private JTextField lowerTextField;
    private JTextField positionNameField;
    private SwitchStatePanel switchCheckPanel;
    private JTextField upperTextField;

    public SwitchEntryPanel(WioSwitchEditor ed) {
        this.buttonGroup = ed.initailButtonGroup;
        this.initComponents();
        this.editor = ed;
        this.initialRadioButton.setFocusable(false);
        this.bidirectionalCheckBox.setFocusable(false);
        this.allowVirtualPositions(false);
        this.headingTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                this.headingTextField(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                try {
                    int n = Integer.valueOf(SwitchEntryPanel.this.headingTextField.getText());
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(SwitchEntryPanel.this.editor, "Heading is not a valid integer", "Warning", 2);
                }
            }

            private void headingTextField(FocusEvent evt) {
                SwitchEntryPanel.this.headingTextField.selectAll();
            }
        });
        this.bwTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                this.bwTextFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                try {
                    int n = Integer.valueOf(SwitchEntryPanel.this.bwTextField.getText());
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(SwitchEntryPanel.this.editor, "Beamwidth is not a valid integer", "Warning", 2);
                }
            }

            private void bwTextFieldFocusGained(FocusEvent evt) {
                SwitchEntryPanel.this.bwTextField.selectAll();
            }
        });
    }

    private void initComponents() {
        this.initialRadioButton = new JRadioButton();
        this.positionNameField = new JTextField();
        this.headingTextField = new JTextField();
        this.bwTextField = new JTextField();
        this.bidirectionalCheckBox = new JCheckBox();
        this.upperTextField = new JTextField();
        this.lowerTextField = new JTextField();
        this.switchCheckPanel = new SwitchStatePanel(this);
        this.expandVirtualPosition = new JButton();
        this.buttonGroup.add(this.initialRadioButton);
        this.initialRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SwitchEntryPanel.this.stateChange(evt);
            }
        });
        this.positionNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SwitchEntryPanel.this.positionNameFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SwitchEntryPanel.this.positionNameFieldFocusLost(evt);
            }
        });
        this.positionNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SwitchEntryPanel.this.positionNameFieldKeyTyped(evt);
            }
        });
        this.headingTextField.setHorizontalAlignment(11);
        this.headingTextField.setText("0");
        this.headingTextField.setEnabled(false);
        this.headingTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SwitchEntryPanel.this.positionNameFieldKeyTyped(evt);
            }
        });
        this.bwTextField.setHorizontalAlignment(11);
        this.bwTextField.setText("0");
        this.bwTextField.setEnabled(false);
        this.bwTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SwitchEntryPanel.this.positionNameFieldKeyTyped(evt);
            }
        });
        this.bidirectionalCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SwitchEntryPanel.this.stateChange(evt);
            }
        });
        this.upperTextField.setEnabled(false);
        this.upperTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwitchEntryPanel.this.upperTextFieldActionPerformed(evt);
            }
        });
        this.upperTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwitchEntryPanel.this.upperTextFieldPropertyChange(evt);
            }
        });
        this.upperTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SwitchEntryPanel.this.lowerTextFieldKeyTyped(evt);
            }
        });
        this.lowerTextField.setEnabled(false);
        this.lowerTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwitchEntryPanel.this.lowerTextFieldPropertyChange(evt);
            }
        });
        this.lowerTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SwitchEntryPanel.this.lowerTextFieldKeyTyped(evt);
            }
        });
        this.expandVirtualPosition.setText("...");
        this.expandVirtualPosition.setToolTipText("Edit Virtual Positions");
        this.expandVirtualPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwitchEntryPanel.this.expandVirtualPositionActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.expandVirtualPosition, -2, 22, -2).addGap(18, 18, 18).addComponent(this.positionNameField, -1, 131, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bidirectionalCheckBox, -2, 29, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.headingTextField, -1, 62, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bwTextField, -1, 60, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.switchCheckPanel, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.lowerTextField, -1, 62, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.upperTextField, -1, 61, Short.MAX_VALUE).addGap(22, 22, 22)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.switchCheckPanel, -2, 29, -2).addComponent(this.upperTextField, -1, -1, -2).addComponent(this.lowerTextField, -1, -1, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.positionNameField, -2, -1, -2).addComponent(this.headingTextField, -2, 27, -2).addComponent(this.bwTextField, -2, 27, -2).addComponent(this.expandVirtualPosition)).addComponent(this.bidirectionalCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void stateChange(ItemEvent evt) {
        this.editor.propertyChange();
    }

    private void positionNameFieldKeyTyped(KeyEvent evt) {
        this.editor.propertyChange();
    }

    private void lowerTextFieldPropertyChange(PropertyChangeEvent evt) {
        this.editor.propertyChange();
    }

    private void upperTextFieldPropertyChange(PropertyChangeEvent evt) {
        this.editor.propertyChange();
    }

    private void lowerTextFieldKeyTyped(KeyEvent evt) {
        this.editor.propertyChange();
    }

    private void expandVirtualPositionActionPerformed(ActionEvent evt) {
        VirtualPositionsDialog vp = new VirtualPositionsDialog((Frame)this.editor, this.editor, true, this.getPositionName());
        vp.setVisible(true);
    }

    private void positionNameFieldFocusGained(FocusEvent evt) {
        if (this.editor.isVirtualSwitch()) {
            this.savedPositionName = this.getPositionName();
        }
    }

    private void positionNameFieldFocusLost(FocusEvent evt) {
        if (this.editor.isVirtualSwitch() && !this.savedPositionName.equals(this.getPositionName())) {
            this.editor.replaceVirtualListElements(this.savedPositionName, this.getPositionName());
        }
    }

    private void upperTextFieldActionPerformed(ActionEvent evt) {
    }

    void checkChanged() {
        this.editor.propertyChange();
    }

    void setInitialSetting(boolean b) {
        this.initialRadioButton.setSelected(b);
    }

    void setPositionNameField(String s) {
        this.positionNameField.setText(s);
    }

    void setHeading(int az) {
        this.headingTextField.setText("" + az);
    }

    void setBeamwidth(int az) {
        this.bwTextField.setText("" + az);
    }

    void setStateArray(int[] array) {
        this.switchCheckPanel.setStateArray(array);
    }

    public boolean isInitialSetting() {
        return this.initialRadioButton.isSelected();
    }

    public int[] getStateArray() {
        return this.switchCheckPanel.getStateArray();
    }

    public int getHeading() {
        return Integer.parseInt(this.headingTextField.getText());
    }

    public int getBeamwidth() {
        return Integer.parseInt(this.bwTextField.getText());
    }

    public String getPositionName() {
        return this.positionNameField.getText();
    }

    public void setLowerFreq(double d) {
        this.lowerTextField.setText("" + d);
    }

    public void setUpperFreq(double d) {
        this.upperTextField.setText("" + d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLowerFreq() {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.lowerTextField.getText());
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getUpperFreq() {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.upperTextField.getText());
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return d;
        }
    }

    void allowHeadings(boolean b) {
        this.headingTextField.setEnabled(b);
        this.bwTextField.setEnabled(b);
        this.headingTextField.setFocusable(b);
        this.bwTextField.setFocusable(b);
    }

    void allowFrequency(boolean b) {
        this.lowerTextField.setEnabled(b);
        this.upperTextField.setEnabled(b);
    }

    void allowVirtualPositions(boolean b) {
        this.expandVirtualPosition.setVisible(b);
    }

    void allowSwitchCheckPanel(boolean b) {
        this.switchCheckPanel.setEnabled(b);
    }

    boolean isBidirectional() {
        return this.bidirectionalCheckBox.isSelected();
    }

    void setBidirectional(boolean b) {
        this.bidirectionalCheckBox.setSelected(b);
    }
}

