/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.wio;

import com.ghe.gh_everyware_server.IPServer;
import com.ghe.wio.IWioStackMatch;
import com.ghe.wio.LogicalDevice;
import com.ghe.wio.StackMatchListener;
import com.ghe.wio.WioBase;
import com.ghe.wio.WioPhysicalRemote;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class WioStackMatch
implements IWioStackMatch,
LogicalDevice {
    private volatile int status = 4;
    private final int address;
    private final boolean[] ants = new boolean[]{true, true, true, true};
    private int remoteRSSI = 0;
    protected final List<StackMatchListener> listenerList = Collections.synchronizedList(new ArrayList());
    private String name;
    private WioPhysicalRemote physicalRemote;
    private String[] antennaNames = new String[]{"", "", "", ""};
    private int antsNr = 0;
    private boolean open;
    private boolean[] lastState = new boolean[0];
    private int updateCounter;
    private final int stackType;
    private IPServer ipServer;

    public WioStackMatch(int address, WioPhysicalRemote remote, int stackType) throws Exception {
        this.address = address;
        this.physicalRemote = remote;
        this.stackType = stackType;
        remote.addLogicalDevice(this);
        this.open = true;
    }

    @Override
    public void initializeStack() {
        int[] rVal = new int[8];
        if (this.stackType == 32 || this.stackType == 64) {
            System.out.println("initialize this stack");
            if (this.stackType == 32) {
                rVal[0] = 1;
                rVal[1] = 1;
                rVal[2] = 1;
                rVal[3] = 1;
                rVal[4] = -1;
                rVal[5] = -1;
                rVal[6] = -1;
                rVal[7] = -1;
            }
            if (this.stackType == 64) {
                rVal[4] = 1;
                rVal[5] = 1;
                rVal[6] = 1;
                rVal[7] = 1;
                rVal[0] = -1;
                rVal[1] = -1;
                rVal[2] = -1;
                rVal[3] = -1;
            }
            this.physicalRemote.requestSwitch(rVal);
            System.out.println(rVal);
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.antennaNames = name.split(",");
        this.antsNr = 0;
        for (int i = 0; i < this.antennaNames.length; ++i) {
            if (this.antennaNames[i].equals("")) continue;
            ++this.antsNr;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        this.open = false;
        this.physicalRemote.removeLogicalDevice(this);
    }

    @Override
    public int getAddress() {
        return this.address;
    }

    @Override
    public WioBase getWioBase() {
        return this.physicalRemote.getWioBase();
    }

    @Override
    public synchronized boolean getAntenna(int ant) {
        if (ant == 1 || ant == 2 || ant == 3 || ant == 4) {
            return this.ants[ant - 1];
        }
        throw new IllegalArgumentException("Antenna must be 1, 2, 3 or 4.");
    }

    @Override
    public synchronized void setAntenna(String ant, boolean b) throws IOException {
        for (int i = 0; i < this.antennaNames.length; ++i) {
            if (!ant.equalsIgnoreCase(this.antennaNames[i])) continue;
            this.setAntenna(i + 1, b);
        }
    }

    @Override
    public synchronized void setAntenna(int ant, boolean b) throws IOException {
        try {
            int[] request;
            if (ant == 1 || ant == 2 || ant == 3 || ant == 4) {
                for (int i = 0; i < this.antennaNames.length; ++i) {
                    if (IPServer.getIPServerReference().isRotorConnected(this.antennaNames[i])) continue;
                    System.out.println(this.antennaNames[i] + " defined Stack antenna is NOT connected");
                    this.ants[i] = false;
                }
                this.ants[ant - 1] = b;
                byte relayByte = this.calcRelayByte(this.ants);
                request = this.calcRelayIntArray(this.ants);
                for (int i = 0; i < 8; ++i) {
                    System.out.println("Stack " + i + "set to " + request[i]);
                }
            } else {
                throw new IllegalArgumentException("Antenna must be 1, 2, 3 or 4.");
            }
            this.physicalRemote.requestSwitch(request);
        }
        catch (IllegalArgumentException ex) {
            this.ants[ant - 1] = !b;
            ex.printStackTrace();
        }
    }

    private int[] calcRelayIntArray(boolean[] antStates) {
        byte b = this.calcRelayByte(antStates);
        int[] rVal = new int[8];
        if (this.stackType == 0) {
            rVal[0] = b & 1;
            rVal[1] = (b & 2) / 2;
            rVal[2] = (b & 4) / 4;
            rVal[3] = (b & 8) / 8;
            rVal[4] = -1;
            rVal[5] = -1;
            rVal[6] = -1;
            rVal[7] = -1;
        } else if (this.stackType == 4) {
            rVal[4] = b & 1;
            rVal[5] = (b & 2) / 2;
            rVal[6] = (b & 4) / 4;
            rVal[7] = (b & 8) / 8;
            rVal[0] = -1;
            rVal[1] = -1;
            rVal[2] = -1;
            rVal[3] = -1;
        } else if (this.stackType == 8) {
            rVal[0] = b & 1;
            rVal[1] = (b & 2) / 2;
            rVal[2] = (b & 4) / 4;
            rVal[3] = (b & 8) / 8;
            rVal[4] = (b & 0x10) / 16;
            rVal[5] = (b & 0x20) / 32;
            rVal[6] = -1;
            rVal[7] = -1;
        } else if (this.stackType == 16) {
            rVal[0] = b & 1;
            rVal[1] = (b & 2) / 2;
            rVal[2] = (b & 4) / 4;
            rVal[3] = (b & 8) / 8;
            rVal[4] = (b & 0x10) / 16;
            rVal[5] = (b & 0x20) / 32;
            rVal[6] = (b & 0x40) / 64;
            rVal[7] = -1;
        } else if (this.stackType == 32) {
            rVal[0] = b & 1;
            rVal[1] = (b & 2) / 2;
            rVal[2] = (b & 4) / 4;
            rVal[3] = (b & 8) / 8;
            rVal[4] = -1;
            rVal[5] = -1;
            rVal[6] = -1;
            rVal[7] = -1;
        } else if (this.stackType == 64) {
            rVal[4] = b & 1;
            rVal[5] = (b & 2) / 2;
            rVal[6] = (b & 4) / 4;
            rVal[7] = (b & 8) / 8;
            rVal[0] = -1;
            rVal[1] = -1;
            rVal[2] = -1;
            rVal[3] = -1;
        }
        return rVal;
    }

    private byte calcRelayByte(boolean[] antStates) {
        byte rVal = 0;
        int numAnts = 0;
        if (this.stackType == 0 || this.stackType == 4) {
            if (antStates[0]) {
                rVal = (byte)(rVal + 2);
                ++numAnts;
            }
            if (antStates[1]) {
                rVal = (byte)(rVal + 4);
                ++numAnts;
            }
            if (antStates[2]) {
                rVal = (byte)(rVal + 8);
                ++numAnts;
            }
            if (numAnts == 0) {
                throw new IllegalArgumentException("You must have at least one antenna selected.");
            }
            if (numAnts == 1) {
                rVal = (byte)(rVal + 1);
            } else {
                rVal = (byte)(rVal + 1);
                rVal = ~rVal;
                rVal = (byte)(rVal & 0xF);
            }
        } else if (this.stackType == 8) {
            if (antStates[0]) {
                rVal = (byte)(rVal + 1);
                ++numAnts;
            }
            if (antStates[1]) {
                rVal = (byte)(rVal + 2);
                ++numAnts;
            }
            if (antStates[2]) {
                rVal = (byte)(rVal + 4);
                ++numAnts;
            }
            if (antStates[3]) {
                rVal = (byte)(rVal + 8);
                ++numAnts;
            }
            if (numAnts == 0) {
                throw new IllegalArgumentException("You must have at least one antenna selected.");
            }
            if (numAnts == 1) {
                rVal = (byte)(rVal + 32);
            } else if (numAnts == 2 || numAnts == 3) {
                rVal = (byte)(rVal + 32);
                rVal = ~rVal;
                rVal = (byte)(rVal & 0x2F);
                rVal = (byte)(rVal + 16);
            } else {
                rVal = 0;
            }
        } else if (this.stackType == 16) {
            rVal = 15;
            if (antStates[0]) {
                rVal = (byte)(rVal - 1);
                ++numAnts;
            }
            if (antStates[1]) {
                rVal = (byte)(rVal - 2);
                ++numAnts;
            }
            if (antStates[2]) {
                rVal = (byte)(rVal - 4);
                ++numAnts;
            }
            if (antStates[3]) {
                rVal = (byte)(rVal - 8);
                ++numAnts;
            }
            if (numAnts == 0) {
                throw new IllegalArgumentException("You must have at least one antenna selected.");
            }
            rVal = numAnts == 1 ? (byte)(rVal + 64) : (numAnts == 2 ? (byte)(rVal + 48) : (numAnts == 3 ? (byte)(rVal + 16) : (byte)0));
        }
        if (this.stackType == 32 || this.stackType == 64) {
            if (antStates[0]) {
                rVal = (byte)(rVal + 1);
                ++numAnts;
            }
            if (antStates[1]) {
                rVal = (byte)(rVal + 2);
                ++numAnts;
            }
            if (antStates[2]) {
                rVal = (byte)(rVal + 4);
                ++numAnts;
            }
            if (numAnts == 0) {
                throw new IllegalArgumentException("You must have at least one antenna selected.");
            }
            if (numAnts == 2 || numAnts == 3) {
                rVal = (byte)(rVal + 8);
            }
        }
        return rVal;
    }

    @Override
    public void addStackMatchListener(StackMatchListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeStackMatchListener(StackMatchListener listener) {
        this.listenerList.remove(listener);
    }

    protected void fireUpdate() {
        WioStackMatch sm = this;
        for (int i = 0; i < this.listenerList.size(); ++i) {
            this.listenerList.get(i).stackMatchUpdate(sm, this.ants, this.status, this.remoteRSSI);
        }
    }

    @Override
    public boolean isPortOpen() {
        return this.open;
    }

    @Override
    public void physicalStatusChanged(boolean[] currentState, int status, int remoteRSSI) {
        if (!Arrays.equals(currentState, this.lastState) || this.status != status || remoteRSSI != this.remoteRSSI) {
            this.fireUpdate();
            this.updateCounter = 0;
        } else if (this.updateCounter % 5 == 0) {
            this.fireUpdate();
        }
        ++this.updateCounter;
        this.lastState = currentState;
        this.status = status;
        this.remoteRSSI = remoteRSSI;
    }
}

