/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.wio;

import com.ghe.gh_everyware_server.IPServer;
import com.ghe.wio.IWioSwitch;
import com.ghe.wio.IWioSwitchModel;
import com.ghe.wio.LogicalDevice;
import com.ghe.wio.WioBase;
import com.ghe.wio.WioPhysicalRemote;
import com.ghe.wio.WioSwitchListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WioSwitch
implements IWioSwitch,
LogicalDevice {
    private final IWioSwitchModel model;
    private volatile int status = -1;
    private final int address;
    private boolean lockout;
    private volatile String state = "UNKNOWN";
    private volatile ArrayList<String> selectedStates;
    protected final List<WioSwitchListener> listenerList = Collections.synchronizedList(new ArrayList());
    private final String name;
    private WioPhysicalRemote physicalRemote;
    private boolean open;
    private int remoteRSSI = 0;
    private boolean[] lastState = new boolean[0];
    private int updateCounter;
    private final Properties props = new Properties();
    private final String propFilename;
    private boolean isAllMomentary;
    private final ArrayList<Integer> momBitsUsed;

    public WioSwitch(int address, WioPhysicalRemote wio, IWioSwitchModel model, String name) throws Exception {
        this.name = name;
        this.propFilename = IPServer.getUserDirectory() + "switchstate" + URLEncoder.encode(name, "UTF-8") + ".properties";
        this.address = address;
        this.model = model;
        this.lockout = this.lockout;
        this.selectedStates = new ArrayList();
        this.momBitsUsed = new ArrayList();
        this.isAllMomentary = true;
        for (String s : model.getPositionNames()) {
            int[] mask = model.getMask(s);
            for (int i = 0; i < mask.length; ++i) {
                if (mask[i] == 1) {
                    this.isAllMomentary = false;
                }
                if (mask[i] != 2) continue;
                this.momBitsUsed.add(i);
            }
        }
        if (this.isVirtualSwitch()) {
            this.isAllMomentary = false;
        }
        String bankPositionString = "NONE_SELECTED";
        if (model.getDisplayType() == 4) {
            bankPositionString = this.loadInitialState();
            System.out.println("INITIAL POSITION: " + bankPositionString);
        } else {
            this.state = this.loadInitialState();
        }
        this.physicalRemote = wio;
        wio.addLogicalDevice(this);
        this.open = true;
        if (model.getDisplayType() == 4) {
            String[] pos = bankPositionString.split(",");
            List<String> strs = Arrays.asList(pos);
            ArrayList<String> cleanStrs = new ArrayList<String>();
            for (String s : strs) {
                if (!this.model.getPositionNames().contains(s)) continue;
                cleanStrs.add(s);
            }
            this.selectedStates.addAll(cleanStrs);
            if (cleanStrs.size() > 0) {
                this.initializeState((String)cleanStrs.get(0), true);
            }
        } else {
            this.initializeState(this.state);
        }
    }

    @Override
    public void addWioSwitchListener(WioSwitchListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeWioSwitchListener(WioSwitchListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public IWioSwitchModel getModel() {
        return this.model;
    }

    @Override
    public WioBase getWioBase() {
        return this.physicalRemote.getWioBase();
    }

    public synchronized void initializeState(String position) throws IOException {
        try {
            if (this.model.getPositionNames().contains(position)) {
                if (this.model.getDisplayType() == 4) {
                    System.out.println("HERE");
                    this.initializeState(position, !this.selectedStates.contains(position));
                } else {
                    this.state = position;
                    int[] mask = this.model.getMask(position);
                    this.physicalRemote.initializeSwitch(mask);
                }
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public synchronized void setState(String position) throws IOException {
        try {
            if (this.model.getPositionNames().contains(position)) {
                if (this.model.getDisplayType() == 4) {
                    this.setState(position, !this.selectedStates.contains(position));
                } else {
                    this.state = position;
                    if (!this.isVirtualSwitch()) {
                        int[] mask = this.model.getMask(position);
                        this.physicalRemote.requestSwitch(mask);
                    } else {
                        this.saveInitialState();
                    }
                }
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setState(String position, boolean on) {
        try {
            if (this.model.getPositionNames().contains(position)) {
                if (!this.selectedStates.contains(position) && on) {
                    this.selectedStates.add(position);
                } else if (this.selectedStates.contains(position) && !on) {
                    this.selectedStates.remove(position);
                }
                this.state = position;
                int[] mask = this.model.getMask(this.selectedStates, this.getPositionNames());
                System.out.println(Arrays.toString(mask));
                this.physicalRemote.requestSwitch(mask);
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    public void initializeState(String position, boolean on) {
        try {
            if (this.model.getPositionNames().contains(position)) {
                if (!this.selectedStates.contains(position) && on) {
                    this.selectedStates.add(position);
                } else if (this.selectedStates.contains(position) && !on) {
                    this.selectedStates.remove(position);
                }
                this.state = position;
                int[] mask = this.model.getMask(this.selectedStates, this.getPositionNames());
                System.out.println(Arrays.toString(mask));
                this.physicalRemote.initializeSwitch(mask);
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public synchronized String getState() {
        if (this.model.getDisplayType() == 4) {
            return this.getBankPositions();
        }
        return this.state;
    }

    @Override
    public void close() {
        this.open = false;
        this.physicalRemote.removeLogicalDevice(this);
        this.saveInitialState();
    }

    @Override
    public int getAddress() {
        return this.address;
    }

    protected void fireUpdate() {
        WioSwitch sw = this;
        for (int i = 0; i < this.listenerList.size(); ++i) {
            if (this.model.getDisplayType() == 4) {
                this.listenerList.get(i).wioSwitchUpdate(sw, this.getBankPositions(), this.status, this.remoteRSSI);
                continue;
            }
            this.listenerList.get(i).wioSwitchUpdate(sw, this.state, this.status, this.remoteRSSI);
        }
    }

    public String getBankPositions() {
        StringBuilder sb = new StringBuilder();
        if (this.selectedStates.size() > 0) {
            for (int i = 0; i < this.selectedStates.size() - 1; ++i) {
                sb.append(this.selectedStates.get(i));
                sb.append(",");
            }
            sb.append(this.selectedStates.get(this.selectedStates.size() - 1));
        } else {
            sb.append("NONE_SELECTED");
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPortOpen() {
        return this.open;
    }

    @Override
    public Vector getPositionNames() {
        return this.model.getPositionNames();
    }

    @Override
    public boolean isVirtualSwitch() {
        return this.model.isVirtualSwitch();
    }

    @Override
    public ArrayList getVirtualSwitches() {
        return this.model.getVirtualSwitches();
    }

    @Override
    public void physicalStatusChanged(boolean[] currentState, int status, int remoteRSSI) {
        if (!Arrays.equals(currentState, this.lastState) || this.status != status || remoteRSSI != this.remoteRSSI) {
            if (this.isAllMomentary) {
                boolean turnOff = true;
                for (int i : this.momBitsUsed) {
                    if (!currentState[i]) continue;
                    turnOff = false;
                }
                if (turnOff) {
                    this.state = "UNKNOWN";
                }
            }
            this.fireUpdate();
            this.updateCounter = 0;
        } else if (this.updateCounter % 5 == 0) {
            this.fireUpdate();
        }
        ++this.updateCounter;
        if (!Arrays.equals(this.lastState, currentState)) {
            this.lastState = currentState;
            this.saveInitialState();
        }
        this.lastState = currentState;
        this.status = status;
        this.remoteRSSI = remoteRSSI;
    }

    private void saveInitialState() {
        try {
            if (this.model.getDisplayType() == 4) {
                this.props.put(this.name, "" + this.getBankPositions());
            } else {
                this.props.put(this.name, "" + this.state);
            }
            this.props.store(new FileOutputStream(this.propFilename), "");
        }
        catch (IOException ex) {
            Logger.getLogger(WioSwitch.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String loadInitialState() {
        try {
            this.props.load(new FileInputStream(this.propFilename));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String rVal = this.props.getProperty(this.name, null);
        return rVal;
    }
}

