/*
 * Decompiled with CFR 0.152.
 */
package com.ghe.wio;

import com.ghe.wio.IWioSwitchModel;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WioSwitchModel
implements IWioSwitchModel,
Serializable {
    final long serialVersionUID = -6677771127325814L;
    private String name;
    private Boolean matrixLockout = false;
    private Boolean virtualSwitch = false;
    private String initialValue = null;
    private Map<String, int[]> positionsTable = Collections.synchronizedMap(new HashMap());
    private Map<String, Integer> heading = Collections.synchronizedMap(new HashMap());
    private Map<String, Integer> beamwidth = Collections.synchronizedMap(new HashMap());
    private Map<String, Boolean> bidir = Collections.synchronizedMap(new HashMap());
    private int displayType = 1;
    protected Vector<String> positionsVector = null;
    private Map<String, Double> lower = Collections.synchronizedMap(new HashMap());
    private Map<String, Double> upper = Collections.synchronizedMap(new HashMap());
    private ArrayList<String[]> virtualPositionsArrayList = new ArrayList();

    public WioSwitchModel(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setMatrixLockout(boolean lockout) {
        this.matrixLockout = lockout;
    }

    @Override
    public boolean isMatrixLockout() {
        return this.matrixLockout;
    }

    public void setVirtualSwitch(boolean virtual) {
        this.virtualSwitch = virtual;
    }

    @Override
    public boolean isVirtualSwitch() {
        return this.virtualSwitch;
    }

    public void setBidirectional(String posName, boolean bidirectional) {
        this.bidir.put(posName, bidirectional);
    }

    @Override
    public boolean isBidirectional(String posName) {
        Boolean b = this.bidir.get(posName);
        if (b == null) {
            b = false;
        }
        return b;
    }

    @Override
    public void setSwitchingTable(Map<String, int[]> positionsTable) {
        this.positionsTable = positionsTable;
    }

    @Override
    public void setDisplayType(int type) {
        this.displayType = type;
    }

    public String getInitialState() {
        return this.initialValue;
    }

    @Override
    public int[] getMask(String state) {
        if (state == null) {
            return new int[8];
        }
        int[] mask = this.positionsTable.get(state);
        int[] rVal = mask == null ? new int[8] : mask;
        return rVal;
    }

    @Override
    public int[] getMask(ArrayList<String> selectedStates, List<String> allStates) {
        int i;
        int[] mask;
        int[] rVal = new int[8];
        Arrays.fill(rVal, -1);
        allStates.remove(selectedStates);
        for (String position : allStates) {
            mask = this.getMask(position);
            for (i = 0; i < rVal.length; ++i) {
                if (mask[i] != 1) continue;
                rVal[i] = 0;
            }
        }
        for (String position : selectedStates) {
            mask = this.getMask(position);
            for (i = 0; i < rVal.length; ++i) {
                if (mask[i] != 1) continue;
                rVal[i] = 1;
            }
        }
        return rVal;
    }

    @Override
    public int getHeading(String s) {
        Integer i = this.heading.get(s);
        if (i == null) {
            i = 0;
        }
        return i;
    }

    @Override
    public int getBeamwidth(String s) {
        Integer i = this.beamwidth.get(s);
        if (i == null) {
            i = 0;
        }
        return i;
    }

    public void setVirtualSwitchEntry(String[] str) {
        this.virtualPositionsArrayList.add(str);
    }

    @Override
    public ArrayList getVirtualSwitches() {
        return this.virtualPositionsArrayList;
    }

    @Override
    public void setVirtualSwitches(ArrayList<String[]> vs) {
        this.virtualPositionsArrayList = vs;
    }

    public Vector getPositionNames() {
        return this.positionsVector;
    }

    @Override
    public int getDisplayType() {
        return this.displayType;
    }

    @Override
    public void setHeading(String position, int az) {
        this.heading.put(position, az);
    }

    @Override
    public void setBeamwidth(String position, int bw) {
        this.beamwidth.put(position, bw);
    }

    @Override
    public void setOrderedPositionNames(Vector<String> v) {
        this.positionsVector = v;
    }

    public double getUpperFreq(String pos) {
        Double i = this.upper.get(pos);
        if (i == null) {
            i = 0.0;
        }
        return i;
    }

    public double getLowerFreq(String pos) {
        Double i = this.lower.get(pos);
        if (i == null) {
            i = 0.0;
        }
        return i;
    }

    public void setLowerFrequency(String pos, double mhz) {
        this.lower.put(pos, mhz);
    }

    public void setUpperFrequency(String pos, double mhz) {
        this.upper.put(pos, mhz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toXML() {
        String xmlString = "error writing xml";
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            String root = "WioDevice";
            Element rootElement = document.createElement(root);
            String displayType = null;
            switch (this.getDisplayType()) {
                case 3: {
                    displayType = "BANDSWITCH";
                    break;
                }
                case 2: {
                    displayType = "HEADING";
                    break;
                }
                case 1: {
                    displayType = "SWITCH";
                    break;
                }
                case 4: {
                    displayType = "ON_OFF_BANK";
                    break;
                }
            }
            rootElement.setAttribute("displayType", displayType);
            document.appendChild(rootElement);
            Element nameElement = document.createElement("devicename");
            nameElement.appendChild(document.createTextNode(this.getName()));
            rootElement.appendChild(nameElement);
            String lockoutElement = "false";
            if (this.isMatrixLockout()) {
                lockoutElement = "true";
            }
            rootElement.setAttribute("matrixlockout", lockoutElement);
            String virtualSwitchElement = "false";
            if (this.isVirtualSwitch()) {
                virtualSwitchElement = "true";
            }
            rootElement.setAttribute("virtualSwitch", virtualSwitchElement);
            Element posElement = document.createElement("positions");
            rootElement.appendChild(posElement);
            int i = 0;
            while (true) {
                Element p;
                block36: {
                    int[] stateArray;
                    Element e;
                    block34: {
                        block35: {
                            if (i >= this.positionsVector.size()) break block34;
                            p = document.createElement("position");
                            p.setAttribute("order", "" + i);
                            p.setAttribute("name", this.positionsVector.get(i));
                            p.setAttribute("bidirectional", "" + this.bidir.get(this.positionsVector.get(i)));
                            p.setAttribute("heading", "" + this.getHeading(this.positionsVector.get(i)));
                            p.setAttribute("beamwidth", "" + this.getBeamwidth(this.positionsVector.get(i)));
                            p.setAttribute("lowerFreq", "" + this.getLowerFreq(this.positionsVector.get(i)));
                            p.setAttribute("upperFreq", "" + this.getUpperFreq(this.positionsVector.get(i)));
                            if (!this.isVirtualSwitch()) break block35;
                            Iterator<String[]> itr = this.virtualPositionsArrayList.iterator();
                            while (itr.hasNext()) {
                                String[] strArray = new String[3];
                                strArray = itr.next();
                                if (!strArray[0].equals(this.positionsVector.get(i))) continue;
                                e = document.createElement("real");
                                e.setAttribute("name", strArray[1]);
                                e.setAttribute("position", strArray[2]);
                                p.appendChild(e);
                            }
                            break block36;
                        }
                        stateArray = this.getMask(this.positionsVector.get(i));
                        break;
                    }
                    for (int j = stateArray.length - 1; j > -1; --j) {
                        e = document.createElement("pin");
                        e.setAttribute("number", "" + j);
                        switch (stateArray[j]) {
                            case -1: {
                                e.setAttribute("state", "dont-care");
                                break;
                            }
                            case 0: {
                                e.setAttribute("state", "off");
                                break;
                            }
                            case 1: {
                                e.setAttribute("state", "on");
                                break;
                            }
                            case 2: {
                                e.setAttribute("state", "momentary");
                                break;
                            }
                            default: {
                                e.setAttribute("state", "off");
                            }
                        }
                        p.appendChild(e);
                    }
                }
                posElement.appendChild(p);
                ++i;
            }
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(WioSwitchModel.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                try {
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource source = new DOMSource(document);
                    StreamResult result = new StreamResult(new StringWriter());
                    transformer.setOutputProperty("indent", "yes");
                    transformer.transform(source, result);
                    return result.getWriter().toString();
                }
                catch (TransformerException ex) {
                    Logger.getLogger(WioSwitchModel.class.getName()).log(Level.SEVERE, null, ex);
                    return xmlString;
                }
            }
            catch (Throwable throwable) {
                return xmlString;
            }
        }
    }
}

